package com.rapid.j2ee.framework.core.reflect.invoker;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvoker implements MethodTargetContainer, FieldInvoker, Invoker {

	private Class<?> type;

	private Method method;

	private Field field;
	
	private Class targetClz;
	

	public MethodInvoker(Class clz, Method method) {

		this.method = method;
		this.targetClz = clz;

		if (method.getParameterTypes().length == 1) {
			type = method.getParameterTypes()[0];
		} else {
			type = method.getReturnType();
		}

		initField(clz);
	}

	private void initField(Class targetClz) {

		if (!invokerName().startsWith("get")
				&& !invokerName().startsWith("set")) {

		}

		try {
			this.field = targetClz.getDeclaredField(invokerName());
		} catch (Exception e) {

		}
	}

	public Object invoke(Object target, Object[] args)
			throws IllegalAccessException, InvocationTargetException {
		return method.invoke(target, args);
	}

	public Class<?> getType() {
		return type;
	}

	public String toString() {
		return this.getClass().getName() + "." + this.method.getName();
	}

	public String invokerName() {
		return getPossibleFieldName(method.getName());
	}

	public Field getField() {
		return field;
	}

	private static String getPossibleFieldName(String invokerName) {

		String possibleField = invokerName.substring(3);

		if (possibleField.length() == 1) {
			possibleField = possibleField.toLowerCase();
		} else {
			possibleField = possibleField.substring(0, 1).toLowerCase()
					+ possibleField.substring(1);
		}

		return possibleField;
	}

	public boolean target(Class clz) {
		
		return targetClz == clz;
	}

	public Method getMethod() {
		return method;
	}
}
