package com.rapid.j2ee.framework.core.reflect.invoker;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class SetFieldInvoker implements FieldInvoker {
	private Field field;

	public SetFieldInvoker(Field field) {
		this.field = field;
	}

	public Object invoke(Object target, Object[] args)
			throws IllegalAccessException, InvocationTargetException {
		field.set(target, args[0]);
		return null;
	}

	public Class<?> getType() {
		return field.getType();
	}

	public Field getField() {

		return field;
	}

	public String invokerName() {
		return field.getName();
	}
}
