package com.rapid.j2ee.framework.core.reflect.property;

import java.util.Iterator;

public class PropertyTokenizer implements Iterable<PropertyTokenizer>,
		Iterator<PropertyTokenizer> {
	private String name;

	private String indexedName;

	private String index;

	private String children;

	public PropertyTokenizer(String fullname) {
		int delim = fullname.indexOf('.');
		if (delim > -1) {
			name = fullname.substring(0, delim);
			children = fullname.substring(delim + 1);
		} else {
			name = fullname;
			children = null;
		}
		indexedName = name;
		delim = name.indexOf('[');
		if (delim > -1) {
			index = name.substring(delim + 1, name.length() - 1);
			name = name.substring(0, delim);
		}
	}

	public String getName() {
		return name;
	}

	public String getIndex() {
		return index;
	}

	public String getIndexedName() {
		return indexedName;
	}

	public String getChildren() {
		return children;
	}

	public boolean hasNext() {
		return children != null;
	}

	public PropertyTokenizer next() {
		return new PropertyTokenizer(children);
	}

	public void remove() {
		throw new UnsupportedOperationException(
				"Remove is not supported, as it has no meaning in the context of properties.");
	}

	public Iterator<PropertyTokenizer> iterator() {
		return this;
	}
}
