package com.rapid.j2ee.framework.core.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AsynchronousApplicationListener<E extends ApplicationContextEvent>
		implements ApplicationListener<E> {

	private TaskExecutor taskExecutor;

	public void onApplicationEvent(final E event) {

		autowireIfGeneralTaskExecutorExisted(event);

		Assert
				.notNull(
						taskExecutor,
						"Please provide a task executor (JVM thread pool) for Asynchronous task! Bean Name :"
								+ AsynchronousApplicationExecutorName
								+ " or special Bean Name :"
								+ event.getClass().getSimpleName() + "Executor");

		taskExecutor.execute(new Runnable() {

			public void run() {

				doHandleApplicationEvent(event);
			}

		});
	}

	private void autowireIfGeneralTaskExecutorExisted(E event) {

		if (!TypeChecker.isNull(taskExecutor)) {
			return;
		}

		ApplicationContext context = ((ApplicationContextEvent) event)
				.getApplicationContext();

		String executorName = event.getClass().getSimpleName() + "Executor";

		if (context.containsBean(executorName)) {
			taskExecutor = (TaskExecutor) context.getBean(executorName);
			return;
		}

		if (context.containsBean(AsynchronousApplicationExecutorName)) {
			taskExecutor = (TaskExecutor) context
					.getBean(AsynchronousApplicationExecutorName);
			return;
		}

	}

	public void setTaskExecutor(TaskExecutor taskExecutor) {
		this.taskExecutor = taskExecutor;
	}

	protected abstract void doHandleApplicationEvent(E event);

	private static final String AsynchronousApplicationExecutorName = "ApplicationGeneralExecutor";

}
