package com.rapid.j2ee.framework.core.spring;

import java.util.Map;

import org.jboss.spring.vfs.context.VFSXmlWebApplicationContext;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class JBossXmlWebApplicationContext extends VFSXmlWebApplicationContext {

	public JBossXmlWebApplicationContext() {
	}

	@Override
	protected void postProcessBeanFactory(
			ConfigurableListableBeanFactory beanFactory) {

		Map<String, PropertyResourceConfigurer> prcs = beanFactory
				.getBeansOfType(PropertyResourceConfigurer.class);

		if (!prcs.isEmpty()) {

			for (PropertyResourceConfigurer prc : prcs.values()) {

				try {
					prc.postProcessBeanFactory(beanFactory);
				} catch (Exception e) {

				}
			}

		}

	}
}
