package com.rapid.j2ee.framework.core.spring;

import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringIbatisClassPathXmlApplicationContext extends
		ClassPathXmlApplicationContext {

	public SpringIbatisClassPathXmlApplicationContext(String configLocation)
			throws BeansException {
		super(new String[] { configLocation }, true, null);
	}

	public SpringIbatisClassPathXmlApplicationContext(String[] configLocations)
			throws BeansException {
		super(configLocations, true, null);
	}

	@Override
	protected void postProcessBeanFactory(
			ConfigurableListableBeanFactory beanFactory) {

		Map<String, PropertyResourceConfigurer> prcs = beanFactory
				.getBeansOfType(PropertyResourceConfigurer.class);

		if (!prcs.isEmpty()) {

			for (PropertyResourceConfigurer prc : prcs.values()) {

				try {
					prc.postProcessBeanFactory(beanFactory);
				} catch (Exception e) {
				
				}	
			}

		}

	}
}
