package com.rapid.j2ee.framework.core.spring;

import java.net.URL;
import java.util.Properties;

import org.springframework.beans.factory.InitializingBean;

import com.rapid.j2ee.framework.core.utils.PropertiesHelper;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class SpringPropertiesHolder implements InitializingBean {

	public static PropertiesHelper propertiesHelperInstance = null;

	public void setProperties(Properties properies) {

		if (TypeChecker.isNull(propertiesHelperInstance)) {
			propertiesHelperInstance = new PropertiesHelper(properies);
			return;
		}

		propertiesHelperInstance.putAll(properies);

	}

	/**
	 * 清空 holder,只有清空Holder才可以重新设置 Properties
	 */
	public static void clearHolder() {
		propertiesHelperInstance = null;
	}

	public static void setProperty(String key, String value) {
		getRequiredHelper().setProperty(key, value);
	}

	/**
	 * get readonly Properties
	 */
	public static Properties getProperies() {
		return (Properties) getRequiredHelper().getProperties().clone();
	}

	public static boolean getBoolean(String key, boolean defaultValue) {
		try {
			return getRequiredHelper().getBoolean(key, defaultValue);
		} catch (Exception e) {
			return defaultValue;
		}
	}

	public static Boolean getBoolean(String key) {
		return getBoolean(key, false);
	}

	public static Object getClassInstance(String key, Object defaultinstance) {
		return getRequiredHelper().getClassInstance(key, defaultinstance);
	}

	public static Object getClassInstance(String key) {
		return getRequiredHelper().getClassInstance(key);
	}

	public static double getDouble(String key, double defaultValue) {
		try {
			return getRequiredHelper().getDouble(key, defaultValue);
		} catch (Throwable e) {
			return defaultValue;
		}
	}

	public static Double getDouble(String key) {
		try {
			return getRequiredHelper().getDouble(key);

		} catch (Throwable e) {
			return null;
		}
	}

	public static float getFloat(String key, float defaultValue) {
		try {
			return getRequiredHelper().getFloat(key, defaultValue);
		} catch (Throwable e) {
			return defaultValue;
		}
	}

	public static Float getFloat(String key) {
		try {
			return getRequiredHelper().getFloat(key);
		} catch (Throwable e) {
			return null;
		}
	}

	public static int getInt(String key, int defaultValue) {
		try {
			return getRequiredHelper().getInt(key, defaultValue);
		} catch (Throwable e) {
			return defaultValue;
		}
	}

	public static int[] getIntArray(String key) {
		try {
			return getRequiredHelper().getIntArray(key);
		} catch (Throwable e) {
			return new int[0];
		}
	}

	public static Integer getInteger(String key) {
		try {
			return getRequiredHelper().getInteger(key);
		} catch (Throwable e) {
			return null;
		}
	}

	public static long getLong(String key, long defaultValue) {
		try {
			return getRequiredHelper().getLong(key, defaultValue);
		} catch (Throwable e) {
			return defaultValue;
		}
	}

	public static Long getLong(String key) {
		try {
			return getRequiredHelper().getLong(key);
		} catch (Throwable e) {
			return null;
		}
	}

	public static String getProperty(String key, String defaultValue) {
		try {
			return getRequiredHelper().getProperty(key, defaultValue);
		} catch (Throwable e) {
			return defaultValue;
		}
	}

	public static String getProperty(String key) {
		return getProperty(key, "");
	}

	public static boolean getRequiredBoolean(String key) {
		return getRequiredHelper().getRequiredBoolean(key);
	}

	public static double getRequiredDouble(String key) {
		return getRequiredHelper().getRequiredDouble(key);
	}

	public static float getRequiredFloat(String key) {
		return getRequiredHelper().getRequiredFloat(key);
	}

	public static int getRequiredInt(String key) {
		return getRequiredHelper().getRequiredInt(key);
	}

	public static long getRequiredLong(String key) {
		return getRequiredHelper().getRequiredLong(key);
	}

	public static String getRequiredString(String key)
			throws IllegalStateException {

		if (getRequiredHelper().containsKey(key)) {
			return getRequiredHelper().getProperty(key);
		}

		throw new IllegalStateException("Miss Property Key:" + key);
	}

	public static Properties getStartsWithProperties(String prefix) {
		return getRequiredHelper().getStartsWithProperties(prefix);
	}

	public static String[] getStringArray(String key) {
		return getRequiredHelper().getStringArray(key);
	}

	public static URL getURL(String key) throws IllegalArgumentException {
		return getRequiredHelper().getURL(key);
	}

	private static PropertiesHelper getRequiredHelper() {
		assertHolderInited();
		return propertiesHelperInstance;
	}

	public void afterPropertiesSet() throws Exception {
		assertHolderInited();
	}

	private static void assertHolderInited() {
		if (propertiesHelperInstance == null) {
			throw new IllegalStateException(
					"PropertiesHolder.properties must be not null, PropertiesHolder not yet init.");
		}

	}

}
