package com.rapid.j2ee.framework.core.utils;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class ActionContext<T> {

	private com.opensymphony.xwork2.ActionContext context;

	public ActionContext(com.opensymphony.xwork2.ActionContext context) {
		this.context = context;

	}

	public void pushHttpRequestParameterMap(String key) {
		setObjectToContextMap(key, ActionContextUtils.getHttpRequest()
				.getParameterMap());
	}

	public void pushHttpRequestParameterProperties(String key) {
		setObjectToContextMap(key, ActionContextUtils
				.getHttpRequestParameterProperties());
	}

	public boolean pushStackValue(T value) {

		if (TypeChecker.isEmptyObject(value)) {
			return false;
		}
		this.context.getValueStack().push(value);

		return true;
	}

	public boolean setListToContextMap(List value) {

		if (TypeChecker.isEmpty(value)) {
			return false;
		}

		return this.setObjectToContextMap(value.get(0).getClass()
				.getSimpleName()
				+ "s", value);

	}

	public boolean setObjectToContextMap(Class clz, Object value) {

		return setObjectToContextMap(ClassUtils.getShortClassName(clz), value);
	}

	public boolean setObjectToContextMap(String key, Object value) {

		LOG.info("Action Context Map Key:" + key);

		this.context.getContextMap().remove(key);

		if (TypeChecker.isEmptyObject(value)) {
			return false;
		}

		this.context.getContextMap().put(key, value);

		return true;
	}

	public boolean setObjectToContextMapWithClassNameAsKey(Object value) {

		this.context.getContextMap().remove(
				ClassUtils.getShortClassName(value.getClass()));

		if (TypeChecker.isEmptyObject(value)) {
			return false;
		}

		this.context.getContextMap().put(
				ClassUtils.getShortClassName(value.getClass()), value);

		return true;
	}

	public com.opensymphony.xwork2.ActionContext getXworkActionContext() {
		return this.context;
	}

	private static final Log LOG = LogFactory.getLog(ActionContext.class);
}
