package com.rapid.j2ee.framework.core.utils;

import java.util.Properties;

import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;

public class ChinesePinYinProperties {

	private Properties origalChinesePinYinMapper = null;

	private Properties finalChinesePinYinMapper = null;

	private static ChinesePinYinProperties INSTANCE = new ChinesePinYinProperties();

	private ChinesePinYinProperties() {

		origalChinesePinYinMapper = PropertiesUtils.getProperties(
				"ChinesePinYin.properties", Charsets
						.getCharsetInstance(CharsetType.UTF_8), false);

		finalChinesePinYinMapper = new Properties();

		parse();
	}

	public static ChinesePinYinProperties getInsance() {
		return INSTANCE;
	}

	public String getPinYinByChinese(char word) {

		if (!finalChinesePinYinMapper.containsKey(String.valueOf(word))) {
			return String.valueOf(word);
		}

		return finalChinesePinYinMapper.getProperty(String.valueOf(word));

	}

	public String getPinYinByChinese(String words) {

		if (TypeChecker.isEmpty(words)) {
			return words;
		}

		StringBuffer pinyin = new StringBuffer(words.length() * 8);

		for (int i = 0; i < words.length(); i++) {

			pinyin.append(getPinYinByChinese(words.charAt(i)));

		}

		return pinyin.toString();

	}

	public String[] getSmartPinYinWords(String words) {

		if (TypeChecker.isEmpty(words)) {
			return new String[] { "", "" };
		}

		String finalPinYinWords = "";
		String finalFirstPinYinLetters = "";

		for (String word : StringUtils.getSingleWordArrays(words)) {
			word = getPinYinByChinese(word);
			if (TypeChecker.isEmpty(word)) {
				continue;
			}

			finalPinYinWords += word;
			finalFirstPinYinLetters += word.charAt(0);
		}

		return new String[] { finalFirstPinYinLetters.toLowerCase(),
				finalPinYinWords.toLowerCase() };

	}

	private void parse() {

		for (Object pinYin : origalChinesePinYinMapper.keySet()) {

			if (!origalChinesePinYinMapper.containsKey(pinYin)) {
				continue;
			}

			storeChineseWordsBySamePinYin((String) pinYin,
					origalChinesePinYinMapper.getProperty((String) pinYin));
		}

	}

	private void storeChineseWordsBySamePinYin(String pinYin,
			String wordsSamePinYin) {

		if (TypeChecker.isEmpty(wordsSamePinYin)) {
			return;
		}

		pinYin = StringUtils.remove(pinYin, "1", "2", "3", "4", "5", "6", "7",
				"8");

		for (int i = 0; i < wordsSamePinYin.length(); i++) {
			finalChinesePinYinMapper.put(String.valueOf(wordsSamePinYin
					.charAt(i)), pinYin);
		}
	}

	public static void main(String[] args) {

		System.out.println("2 == "
				+ ChinesePinYinProperties.getInsance().getSmartPinYinWords(
						"吕 New Year 中国 人们 London Stree No1")[1]);

	}
}
