package com.rapid.j2ee.framework.core.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ognl.Ognl;
import ognl.OgnlException;

import org.apache.commons.collections.MultiHashMap;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.collections.SortMultiHashMap;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.support.Equalable;
import com.rapid.j2ee.framework.core.utils.support.EqualableTarget;
import com.rapid.j2ee.framework.core.utils.support.ItemFieldNameSelector;
import com.rapid.j2ee.framework.core.utils.support.ItemFieldSelector;
import com.rapid.j2ee.framework.core.utils.support.ItemSelector;
import com.rapid.j2ee.framework.core.utils.support.ItemSingleSelector;

public class CollectionsUtil {

	public static <T> T getEndItem(List<T> collection) {
		return TypeChecker.isEmpty(collection) ? null : collection
				.get(collection.size() - 1);
	}

	public static <T> T getStartItem(List<T> collection) {
		return TypeChecker.isEmpty(collection) ? null : collection.get(0);
	}

	public static int size(List collection) {
		return TypeChecker.isEmpty(collection) ? 0 : collection.size();
	}

	public static <T> T get(List<T> collection, T bean) {

		if (TypeChecker.isEmpty(collection) || !collection.contains(bean)) {
			return null;
		}

		return collection.get(collection.indexOf(bean));
	}

	public static <T> List<List<T>> setMultipleCollectionsByFieldNames(
			List<T> collection, String... fields) {

		if (TypeChecker.isEmpty(collection)) {
			return ObjectUtils.EMPTY_LIST;
		}

		SortMultiHashMap sortMultiValue = new SortMultiHashMap();

		for (T item : collection) {

			sortMultiValue.put(StringUtils.getStringBunchByObjectFieldNames(
					item, "-", fields), item);

		}

		List<List<T>> groupListValues = new ArrayList<List<T>>(5);

		for (Object key : sortMultiValue.keyList()) {
			groupListValues.add(sortMultiValue.getList(key));
		}

		return groupListValues;

	}

	public static <T> Map<String, T> convertCollectionToMapByFieldNames(
			Collection<T> collection, String... fields) {

		if (TypeChecker.isEmpty(collection)) {
			return ObjectUtils.EMPTY_MAP;
		}

		Map<String, T> mapper = new HashMap<String, T>(collection.size());

		for (T item : collection) {

			Object value = BeanUtils.getPropertyObject(item, fields[0]);

			if (fields.length == 1) {

				if (!TypeChecker.isNull(value)) {

					if (value.getClass().isArray()) {

						for (int i = 0, j = Array.getLength(value); i < j; i++) {

							if (item instanceof Cloneable) {
								mapper.put(String.valueOf(Array.get(value, i)),
										(T) InvokeUtils.invoke(item, "clone",
												null, null));

								continue;
							}

							mapper.put(String.valueOf(Array.get(value, i)),
									item);
						}

					}
				}
			}

			mapper.put(StringUtils.getStringBunchByObjectFieldNames(item, "-",
					fields), item);
		}

		return mapper;
	}

	public static MultiHashMap convertCollectionToMultipleMapByFieldNames(
			Collection collection, String... fields) {

		if (TypeChecker.isEmpty(collection)) {
			return ObjectUtils.EMPTY_MULTIHASHMAP;
		}

		MultiHashMap map = new MultiHashMap(collection.size());

		for (Object item : collection) {

			map.put(StringUtils.getStringBunchByObjectFieldNames(item, "-",
					fields), item);
		}

		return map;
	}

	public static void setFieldsValuesForCollectionItems(Collection collection,
			Map<String, Object> fieldValues) {
		if (TypeChecker.isEmpty(collection) || TypeChecker.isEmpty(fieldValues)) {
			return;
		}

		for (Object item : collection) {
			for (String key : fieldValues.keySet()) {
				BeanUtils.setProperty(item, key, fieldValues.get(key));
			}
		}
	}

	public static void setFieldValueForCollectionItems(Collection collection,
			String field, Object value) {
		if (TypeChecker.isEmpty(collection) || TypeChecker.isEmpty(field)) {
			return;
		}

		for (Object item : collection) {
			BeanUtils.setProperty(item, field, value);
		}
	}

	public static List nullToEmpty(List list) {
		return TypeChecker.isNull(list) ? ObjectUtils.EMPTY_LIST : list;
	}

	public static List subtract(List list, List list1) {
		List arraylist = new ArrayList(list);
		for (Iterator iterator = list1.iterator(); iterator.hasNext(); arraylist
				.remove(iterator.next()))
			;
		return arraylist;
	}

	public static List sum(List list, List list1) {
		return subtract(union(list, list1), intersection(list, list1));
	}

	public static List union(List list, List list1) {
		List arraylist = new ArrayList(list);
		arraylist.addAll(list1);
		return arraylist;
	}

	public static List intersection(List list, List list1) {
		List arraylist = new ArrayList();
		for (Iterator iterator = list1.iterator(); iterator.hasNext();) {
			Object obj = iterator.next();
			if (list.contains(obj))
				arraylist.add(obj);
		}

		return arraylist;
	}

	public static List cloneList(List list) {

		if (TypeChecker.isEmpty(list)) {
			return new ArrayList(1);
		}

		return (List) ObjectUtils.cloneObject(list);
	}

	public static List splitListByItemGroupSize(List rs, int length) {
		if (TypeChecker.isEmpty(rs)) {
			return rs;
		}

		return splitListByItemSize(rs, rs.size() % length == 0 ? rs.size()
				/ length : rs.size() / length + 1);
	}

	public static <T> List<List<T>> splitListByItemSize(List<T> rs,
			int singleItemLength) {

		if (TypeChecker.isEmpty(rs)) {
			return ObjectUtils.EMPTY_LIST;
		}
		List<List<T>> items = new ArrayList<List<T>>(rs.size()
				/ singleItemLength + 1);

		List<T> singleItems = null;

		for (int i = 0; i < rs.size(); i++) {

			if (i % singleItemLength == 0) {
				singleItems = new ArrayList<T>(singleItemLength);
				items.add(singleItems);
			}

			singleItems.add(rs.get(i));
		}

		return items;
	}

	public static <T> List<T> find(Collection<T> collection,
			ItemSelector selector, Object... targetObjects) {

		Assert.notNull(selector, "CollectionItemSelector must be provided");

		if (TypeChecker.isEmpty(collection)) {
			return ObjectUtils.EMPTY_LIST;
		}

		boolean singleMatcher = (selector instanceof ItemSingleSelector);

		int capablity = singleMatcher ? 0 : collection.size() / 3;

		List<T> matchedItems = new ArrayList<T>(capablity + 1);

		for (T item : collection) {

			if (accept(selector, item, targetObjects)) {

				matchedItems.add(item);

				if (singleMatcher) {
					return matchedItems;
				}

			}
		}

		return matchedItems;
	}

	private static boolean accept(ItemSelector selector, Object item,
			Object... targetObjects) {

		if (TypeChecker.isEmptyObject(targetObjects)) {
			return selector.accept(selector.resolve(item), targetObjects);
		}

		for (Object target : targetObjects) {

			if (item instanceof Equalable) {

				if (((Equalable) item).equalsObject(target, selector
						.resolve(item))) {
					return true;
				}

				continue;
			}

			if (item instanceof EqualableTarget) {

				if (selector instanceof ItemFieldSelector) {
					if (((EqualableTarget) item).equalsObject(
							((ItemFieldSelector) selector).getFieldName(),
							target, selector.resolve(item))) {
						return true;
					}

				}

				if (((EqualableTarget) item).equalsObject(null, target,
						selector.resolve(item))) {
					return true;
				}

				continue;
			}

			if (selector.accept(selector.resolve(item), target)) {
				return true;
			}
		}

		return false;
	}

	public static <T> List<T> find(Collection<T> collection, String fieldName,
			Object... values) {
		return find(collection, new CollectionItemFieldSelector(fieldName),
				values);
	}

	public static boolean exists(Collection collection, String fieldName,
			Object... values) {
		return !find(collection, new CollectionItemFieldSelector(fieldName),
				values).isEmpty();
	}

	public static <T> T findOne(Collection<T> collection, String fieldName,
			Object... values) {

		List<T> matchedItems = find(collection,
				new CollectionItemFieldSingleSelector(fieldName), values);

		if (TypeChecker.isEmpty(matchedItems)) {
			return null;
		}

		return matchedItems.get(0);
	}

	private static class CollectionItemFieldSingleSelector extends
			CollectionItemFieldSelector implements ItemSingleSelector

	{

		public CollectionItemFieldSingleSelector(String fieldName) {
			super(fieldName);

		}

	}

	protected static class CollectionItemFieldSelector implements ItemSelector,
			ItemFieldSelector {

		private String fieldName;

		public CollectionItemFieldSelector(String fieldName) {
			this.fieldName = fieldName;
		}

		public boolean accept(Object itemConvertedObject, Object comparedObject) {

			return ObjectUtils.nullSafeEquals(itemConvertedObject,
					comparedObject);
		}

		public Object resolve(Object item) {

			if (isOgnlPattern()) {
				try {

					return Ognl.getValue(getOgnlExpression(),
							Collections.EMPTY_MAP, item);
				} catch (OgnlException e) {

					throw ExceptionUtils.convertThrowableToBaseException(e);
				}
			}

			return BeanUtils.getPropertyObject(item, fieldName);
		}

		private String getOgnlExpression() {

			String ognlValue = this.fieldName.substring("${".length());

			return ognlValue.substring(0, ognlValue.length() - 1);
		}

		private boolean isOgnlPattern() {
			return fieldName.startsWith("${") && fieldName.endsWith("}");
		}

		public String getFieldName() {

			return fieldName;
		}

	}

	public static class CollectionItem {

		public CollectionItem(String name) {
			this.name = name;
		}

		private String name;

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getOtherName() {
			return this.name;
		}

		public String toString() {
			return "name:" + this.name;
		}

	}

	public static List getListWithoutNull(List rs) {

		if (TypeChecker.isEmpty(rs)) {
			return rs;
		}

		List newRs = new ArrayList(rs.size());

		for (Object obj : rs) {
			if (TypeChecker.isNull(obj)) {
				continue;
			}

			newRs.add(obj);
		}

		return newRs;
	}

	public static <T> List<T> getListValuesByFieldName(Class<T> clz, List rs,
			String fieldName) {

		if (TypeChecker.isEmpty(rs)) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<T> newRs = new ArrayList<T>(rs.size());

		for (Object obj : rs) {

			newRs.add((T) BeanUtils.getPropertyObject(obj, fieldName));
		}

		return newRs;
	}

	public static <T> Set<T> getSetValuesByFieldName(Class<T> clz, List rs,
			String fieldName) {
		if (TypeChecker.isEmpty(rs)) {
			return ObjectUtils.EMPTY_SET;
		}

		Set<T> newRs = new HashSet<T>(rs.size());

		for (Object obj : rs) {

			newRs.add((T) BeanUtils.getPropertyObject(obj, fieldName));
		}

		return newRs;
	}

	public static <T> List<T> getItemsOfOverOccurredCount(List<T> rs, int count) {

		if (count <= 0) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<T> matchedItems = new ArrayList<T>();

		for (Object item : rs) {

			if (countItem(rs, item) > count) {
				matchedItems.add((T) item);
			}
		}
		return matchedItems;
	}

	public static <T> List<T> getItemsOfOccurredCount(List<T> rs, int count) {
		if (count <= 0) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<T> matchedItems = new ArrayList<T>();

		for (Object item : rs) {

			if (countItem(rs, item) == count) {
				matchedItems.add((T) item);
			}
		}
		return matchedItems;

	}

	public static int countItem(List rs, Object target) {

		if (TypeChecker.isNull(target)) {
			return 0;
		}

		int count = 0;

		for (Object item : rs) {
			if (item == target || target.equals(item)) {
				count++;
			}
		}

		return count;
	}

	public static void linkChildrenUnderParents(final Collection parents,
			final Collection children, String parentCarryChildrenFieldName,
			final String... fieldNamesAsFK) {

		if (TypeChecker.isEmpty(parents) || TypeChecker.isEmpty(children)) {
			return;
		}

		ItemSelector itemFieldNameSelector = new ItemFieldNameSelector(
				fieldNamesAsFK);

		for (Object parent : parents) {

			Field parentChildField = InvokeUtils.findField(parent.getClass(),
					parentCarryChildrenFieldName);

			List matchedChildren = CollectionsUtil.find(children,
					itemFieldNameSelector, parent);

			if (TypeChecker.isEmpty(matchedChildren)) {
				continue;
			}

			// Only Set Method..
			if (TypeChecker.isNull(parentChildField)) {

				Method method = InvokeUtils.findMethod(parent.getClass(), "set"
						+ StringUtils
								.upperStartChar(parentCarryChildrenFieldName));

				Assert.notNull(method);

				Class paramType = method.getParameterTypes()[0];

				if (Collection.class.isAssignableFrom(paramType)) {

					try {
						method.invoke(parent, matchedChildren);
					} catch (Exception e) {
						throw ExceptionUtils.convertThrowableToBaseException(e);
					}

					continue;
				}
				try {
					method.invoke(parent, parentChildField, matchedChildren
							.get(0));
				} catch (Exception e) {
					throw ExceptionUtils.convertThrowableToBaseException(e);
				}

				return;
			}

			if (Collection.class.isAssignableFrom(parentChildField.getType())) {

				InvokeUtils.setSetterMethodOrField(parent, parentChildField,
						matchedChildren);

				continue;
			}

			InvokeUtils.setSetterMethodOrField(parent, parentChildField,
					matchedChildren.get(0));

		}

	}

	public static <T> T[] toArray(Collection<T> items) {

		if (TypeChecker.isNull(items)) {
			return null;
		}

		if (TypeChecker.isEmpty(items)) {
			return (T[]) ObjectUtils.EMPTY_OBJECT_ARRAYS;
		}

		Class clz = items.iterator().next().getClass();

		return items.toArray((T[]) Array.newInstance(clz, items.size()));
	}

	public static <T> T[] toArray(Collection items, Class<T> type) {

		if (TypeChecker.isNull(items)) {
			return null;
		}

		if (TypeChecker.isEmpty(items)) {
			return (T[]) Array.newInstance(type, 0);
		}

		return (T[]) items.toArray((T[]) Array.newInstance(type, items.size()));
	}

	private CollectionsUtil() {

	}

	public static void main(String[] args) {

		List<Date> dates = new ArrayList<Date>();
		dates.add(new Date());
		dates.add(new Date());
		System.out.println(toArray(dates));
	}

	/**
	 * public static void main(String[] args) {
	 * 
	 * List<CollectionItem> rs = new ArrayList<CollectionItem>();
	 * 
	 * CollectionItem item = new CollectionItem("JohnHao");
	 * 
	 * rs.add(item);
	 * 
	 * item = new CollectionItem("JohnHao");
	 * 
	 * rs.add(item);
	 * 
	 * item = new CollectionItem("Tomcat");
	 * 
	 * rs.add(item);
	 * 
	 * System.out.println(CollectionsUtil.findOne(rs, "${otherName+ '_'+ name}",
	 * "Tomcat_Tomcat")); }
	 */

}
