package com.rapid.j2ee.framework.core.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class CookieUtils {

	private static Log logger = LogFactory.getLog(CookieUtils.class);

	public static void addCookie(HttpServletRequest request,
			HttpServletResponse resp, String cookieName, String cookieValue,
			String cookieDomain, String cookiePathName, int cookieAgeUnitSec) {

		cookiePathName = StringUtils.trimToEmpty(cookiePathName, "/");

		Cookie tc = new Cookie(cookieName, cookieValue);

		tc.setMaxAge(cookieAgeUnitSec);
		tc.setPath(cookiePathName);
		tc.setDomain(cookieDomain);

		logger.info("addCookie [name=" + cookieName + " value=" + cookieValue
				+ " domain=" + cookieDomain + " path=" + cookiePathName
				+ " age=" + cookieAgeUnitSec + "]");

		resp.addCookie(tc);

	}

	public static void addCookie(HttpServletRequest request,
			HttpServletResponse resp, String cookieName, String cookieValue,
			int cookieAgeUnitSec) {
		addCookie(request, resp, cookieName, cookieValue, request
				.getServerName(), request.getContextPath(), cookieAgeUnitSec);
	}

	public static void addCookie(String cookieName, String cookieValue,
			String cookiePathName, int cookieAgeUnitSec) {

		addCookie(ActionContextUtils.getHttpRequest(), ActionContextUtils
				.getHttpResponse(), cookieName, cookieValue, ActionContextUtils
				.getHttpRequest().getServerName(), cookiePathName,
				cookieAgeUnitSec);

	}

	public static void addCookie(String cookieName, String cookieValue,
			int cookieAgeUnitSec) {

		addCookie(ActionContextUtils.getHttpRequest(), ActionContextUtils
				.getHttpResponse(), cookieName, cookieValue, cookieAgeUnitSec);

	}

	public static String getCookieValue(Cookie cookie, String defValue) {

		if (TypeChecker.isNull(cookie)
				|| TypeChecker.isEmpty(cookie.getValue())) {
			return defValue;
		}

		return StringUtils.trimToEmpty(cookie.getValue());
	}

	public static Cookie getCookie(String cookieName) {
		return getCookie("", cookieName, ActionContextUtils.getHttpRequest());
	}

	public static Cookie getCookie(String cookieName, HttpServletRequest request) {
		return getCookie("", cookieName, request);
	}

	public static Cookie getCookie(String cookiePath, String cookieName,
			HttpServletRequest request) {

		Cookie[] cookies = request.getCookies();

		if (TypeChecker.isEmpty(cookies)) {
			return null;
		}

		for (Cookie cookie : cookies) {

			if (!cookie.getName().equalsIgnoreCase(cookieName)) {
				continue;
			}

			if (TypeChecker.isEmpty(cookiePath)) {
				return cookie;
			}

			if (StringUtils.equalsIgnoreCase(cookie.getPath(), cookiePath)
					|| StringUtils.trimToEmpty(cookie.getPath()).startsWith(
							cookiePath)) {

				return cookie;

			}

		}

		return null;
	}

	public static void removeCookie(HttpServletRequest request,
			HttpServletResponse resp, String cookieName, String cookiePathName) {

		Cookie[] cs = request.getCookies();

		if (TypeChecker.isNull(cs)) {
			return;
		}

		for (Cookie cookie : cs) {

			if (!cookieName.equalsIgnoreCase(cookie.getName())) {
				continue;
			}

			Cookie cookieRemove = new Cookie(cookie.getName(), null);
			cookieRemove.setMaxAge(0);
			cookieRemove.setDomain(request.getServerName());
			cookieRemove.setPath(request.getContextPath());

			if (TypeChecker.isEmpty(cookiePathName)) {

				resp.addCookie(cookieRemove);

				continue;
			}

			if (StringUtils.equalsIgnoreCase(cookie.getPath(), cookiePathName)
					|| StringUtils.trimToEmpty(cookie.getPath()).startsWith(
							cookiePathName)) {

				resp.addCookie(cookieRemove);
			}
		}

	}

	public static void removeCookie(HttpServletRequest request,
			HttpServletResponse resp, String cookieName) {
		removeCookie(request, resp, cookieName, null);
	}

	public static String getSessionId(String sessionName) {

		Cookie[] cs = ActionContextUtils.getHttpRequest().getCookies();

		if (TypeChecker.isNull(cs)) {
			return "";
		}

		for (Cookie c : cs) {
			if (sessionName.equalsIgnoreCase(c.getName())) {
				return c.getValue();
			}
		}

		return "";
	}

	private CookieUtils() {

	}

}
