package com.rapid.j2ee.framework.core.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.bean.dictionary.item.DictionaryItem;
import com.rapid.j2ee.framework.bean.dictionary.item.DictionaryItemBean;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public final class DateTimeUtils {

	private static final Date Mysql_Null_Date = DateTimeUtils.convertWebToDate(
			"1899-12-29 00:00:00", DateTimeFormat.YYYY_MM_DD_HH_MM_SS);

	private DateTimeUtils() {

	}

	public static Date trunc(Date date, DateTimeFormat dateTimeFormat) {

		return DateTimeUtils.convertWebToDate(DateTimeUtils.convertDateToWeb(
				date, dateTimeFormat), dateTimeFormat);
	}

	public static Date combineDateAndTime(Date date, String time) {

		String timeFormat = DateTimeUtils.getTimePartFormat(" " + time);

		return DateTimeUtils.convertWebToDate(DateTimeUtils.convertDateToWeb(
				date, DateTimeFormat.YYYY_MM_DD)
				+ " " + time, DateTimeFormat
				.getDateTimeFormat(DateTimeFormat.YYYY_MM_DD.getFormat() + " "
						+ timeFormat));
	}

	public static Date getMySqlNullDate() {
		return Mysql_Null_Date;
	}

	public static int getCurrentTimeSecs() {
		return (int) (System.currentTimeMillis() / 1000);
	}

	public static Date convertCurrentTime(long time) {
		// 10 为是Sec
		if (String.valueOf(time).length() == 10) {
			time = time * 1000;
		}

		return new Date(time);
	}

	public static Date getMaxDate(List<Date> dates) {

		dates = CollectionsUtil.getListWithoutNull(dates);

		if (TypeChecker.isEmpty(dates)) {
			return null;
		}

		Collections.sort(dates);

		return dates.get(dates.size() - 1);
	}

	public static Date getMinDate(List<Date> dates) {

		dates = CollectionsUtil.getListWithoutNull(dates);

		if (TypeChecker.isEmpty(dates)) {
			return null;
		}

		Collections.sort(dates);

		return dates.get(0);
	}

	public static int compareDate(Date dateFr, Date dateTo) {

		if (dateFr == dateTo) {
			return 0;
		}

		if (dateFr == null && dateTo != null) {
			return -1;
		}

		if (dateFr != null && dateTo == null) {
			return 1;
		}

		if (dateFr.getTime() == dateTo.getTime()) {
			return 0;
		}

		return dateFr.getTime() - dateTo.getTime() > 0 ? 1 : -1;

	}

	public static int diffDays(Date dateFr, Date dateTo) {

		if (TypeChecker.isNull(dateFr) || TypeChecker.isNull(dateTo)) {
			return 0;
		}

		return (int) ((dateTo.getTime() - dateFr.getTime()) / A_WHOLE_DAY_MILSEC);

	}

	public static int diffMonths(Date dateFr, Date dateTo) {

		if (TypeChecker.isNull(dateFr) || TypeChecker.isNull(dateTo)) {
			return 0;
		}

		int diffValue = 0;

		if (dateTo.before(dateFr)) {
			throw new IllegalArgumentException("Date From must before date to!");
		}
		Date tempFr = new Date(dateFr.getTime());

		int dateToTime = DateTimeUtils.getYear(dateTo) * 100
				+ DateTimeUtils.getMonth(dateTo);
		int dateFrTime = 0;

		do {

			diffValue++;

			tempFr = addDateByMonth(tempFr, 1);

			dateFrTime = DateTimeUtils.getYear(tempFr) * 100
					+ DateTimeUtils.getMonth(tempFr);

		} while (dateFrTime < dateToTime);

		return diffValue;

	}

	public static int diffYears(Date dateFr, Date dateTo) {

		if (TypeChecker.isNull(dateFr) || TypeChecker.isNull(dateTo)) {
			return 0;
		}

		int diffValue = 0;

		if (dateTo.before(dateFr)) {
			throw new IllegalArgumentException("Date From must before date to!");
		}

		return DateTimeUtils.getYear(dateTo) - DateTimeUtils.getYear(dateFr);
	}

	public static Date addDate(Date date, int periods, int pattern) {

		if (TypeChecker.isNull(date) || periods == 0) {
			return date;
		}

		GregorianCalendar calendar = new GregorianCalendar();
		calendar.setTime(date);
		calendar.add(pattern, periods);

		return calendar.getTime();
	}

	public static Date addDateByMin(Date date, int min) {
		return addDate(date, min, Calendar.MINUTE);
	}

	public static Date addDateByMonth(Date date, int month) {
		return addDate(date, month, Calendar.MONTH);
	}

	public static Date addDateByDay(Date date, int days) {
		return addDate(date, days, Calendar.DAY_OF_YEAR);
	}

	public static Date addDateByYear(Date date, int years) {
		return addDate(date, years, Calendar.YEAR);
	}

	public static String convertDateToWeb(Date date, DateTimeFormat format) {
		if (TypeChecker.isNull(date)) {
			return "";
		}
		return format.getSimpleDateFormat().format(date);
	}

	public static Date convertWebToDate(String date, DateTimeFormat format) {

		if (TypeChecker.isEmpty(date)) {
			return null;
		}

		try {
			return format.getSimpleDateFormat().parse(date);
		} catch (Exception e) {
			return null;
		}
	}

	public static Date getCurrentDate() {
		return new Date(System.currentTimeMillis());
	}

	public static Date getCurrentTimestamp() {
		return new Timestamp(System.currentTimeMillis());
	}

	public static java.sql.Date getCurrentSqlDate() {
		return new java.sql.Date(System.currentTimeMillis());
	}

	public static Date getCurrentYMDDate() {
		return convertWebToDate(getCurrentWebDate(DateTimeFormat.YYYY_MM_DD),
				DateTimeFormat.YYYY_MM_DD);
	}

	public static Date getYMDDate(Date date) {

		if (TypeChecker.isNull(date)) {
			return date;
		}

		return convertWebToDate(convertDateToWeb(date,
				DateTimeFormat.YYYY_MM_DD), DateTimeFormat.YYYY_MM_DD);

	}

	public static String getCurrentWebDate(DateTimeFormat format) {
		return convertDateToWeb(getCurrentDate(), format);
	}

	public static int getDayOfWeek(Date date) {

		if (TypeChecker.isNull(date)) {
			return -1;
		}

		GregorianCalendar calendar = new GregorianCalendar();
		calendar.setTime(date);

		int day = calendar.get(Calendar.DAY_OF_WEEK) - 1;

		if (day == 0) {
			return 7;
		}

		return day;

	}

	public static Date getEndDayOfMonth(Date day) {

		return DateTimeUtils.addDateByDay(getFirstDayOfNextMonth(day), -1);

	}

	public static Date getFirstDayOfMonth(Date date) {

		if (TypeChecker.isNull(date)) {
			return null;
		}

		return DateTimeUtils.convertWebToDate(DateTimeUtils.convertDateToWeb(
				date, DateTimeFormat.YYYY_MM)
				+ "-01", DateTimeFormat.YYYY_MM_DD);

	}

	public static Date getFirstDayOfNextMonth(Date day) {

		int curMonth = DateTimeUtils.getMonth(day);

		Date firstDayOfNextMonth = DateTimeUtils.addDateByDay(day, 1);

		while (DateTimeUtils.getMonth(firstDayOfNextMonth) == curMonth) {
			firstDayOfNextMonth = DateTimeUtils.addDateByDay(
					firstDayOfNextMonth, 1);
		}

		return firstDayOfNextMonth;

	}

	public static DatePeriod getWeekPeriodByCurrentDate() {
		return getWeekPeriodByDate(null);
	}

	public static DatePeriod getMonthPeriodByCurrentDate() {

		return getMonthPeriodByDate(null);
	}

	public static DatePeriod getMonthPeriodByDate(Date date) {

		date = getYMDDate(date);

		if (TypeChecker.isNull(date)) {
			date = getCurrentYMDDate();
		}

		Date start = DateTimeUtils.convertWebToDate(DateTimeUtils
				.convertDateToWeb(date, DateTimeFormat.YYYY_MM)
				+ "-01", DateTimeFormat.YYYY_MM_DD);

		return new DatePeriod(DatePeriodType.MONTH_PERIOD, start,
				getEndDayOfMonth(date));
	}

	public static DatePeriod getWeekPeriodByDate(Date date) {

		date = getYMDDate(date);

		if (TypeChecker.isNull(date)) {
			date = getCurrentYMDDate();
		}

		Date monday = date;

		while (getDayOfWeek(monday) != 1) {
			monday = addDateByDay(monday, -1);
		}

		Date sunday = date;

		while (getDayOfWeek(sunday) != 7) {
			sunday = addDateByDay(sunday, 1);
		}

		return new DatePeriod(DatePeriodType.WEEK_PERIOD, monday, sunday);
	}

	public static int getYear(Date date) {
		return getDateTime(date, Calendar.YEAR);
	}

	public static int getMonth(Date date) {
		return getDateTime(date, Calendar.MONTH) + 1;
	}

	public static int getDay(Date date) {
		return getDateTime(date, Calendar.DATE);
	}

	public static int getHour(Date date) {
		return getDateTime(date, Calendar.HOUR);
	}

	public static int getHour24(Date date) {
		return getDateTime(date, Calendar.HOUR_OF_DAY);
	}

	public static int getMinute(Date date) {
		return getDateTime(date, Calendar.MINUTE);
	}

	public static int getSecond(Date date) {
		return getDateTime(date, Calendar.SECOND);
	}

	private static int getDateTime(Date date, int pattern) {
		try {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			return calendar.get(pattern);
		} catch (Exception ep) {
			return -1;
		}
	}

	public static String getTimePartFormat(String dateTime) {
		if (TypeChecker.isEmpty(dateTime)) {
			return "";
		}

		if (dateTime.indexOf(" ") < 0) {
			return "";
		}

		dateTime = StringUtils.substringAfterLast(dateTime, " ");

		if (dateTime.indexOf(".") > 0) {
			return DateTimeFormat.HH_MM_SS_SSS.getFormat();
		}

		int counts = StringUtils.countsByTarget(dateTime, ":");

		if (counts == 0) {
			return "hh";
		}

		if (counts == 1) {
			return DateTimeFormat.HH_MM.getFormat();
		}

		return DateTimeFormat.HH_MM_SS.getFormat();

	}

	public static void main(String[] args) {

		System.out.println(ToStringBuilder.reflectionToString(DateTimeUtils
				.parseDateTimeByFormat("12.03.1991 12:53:00",
						"dd.mm.yyyy hh:mm:ss")));

		System.out
				.println(ToStringBuilder.reflectionToString(DateTimeUtils
						.parseDateTimeByFormat("12.03.1991 12:53",
								"dd.mm.yyyy hh:mm")));

		System.out.println(DateTimeUtils.convertCurrentTime(1398915120)
				.toLocaleString());

	}

	public static final class DatePeriod {

		private Date begin;

		private Date end;

		private DatePeriodType type;

		public DatePeriod(DatePeriodType patternType, Date begin, Date end) {
			this.begin = begin;
			this.end = end;
			this.type = patternType;
		}

		public Date getBegin() {
			return begin;
		}

		public Date getEnd() {
			return end;
		}

		public DatePeriodType getType() {
			return type;
		}

		public String toString() {
			return "Type:" + this.type + " Start:"
					+ this.begin.toLocaleString() + " End:"
					+ this.end.toLocaleString();
		}

	}

	public static java.sql.Date toSqlDate(Date date) {
		if (TypeChecker.isNull(date)) {
			return null;
		}
		return new java.sql.Date(date.getTime());
	}

	public static java.sql.Timestamp toSqlTimestamp(Date date) {
		if (TypeChecker.isNull(date)) {
			return null;
		}
		return new java.sql.Timestamp(date.getTime());
	}

	public static List<DictionaryItem> getYearPeriods(int backYearPeriod) {

		List<DictionaryItem> yearPeriods = new ArrayList<DictionaryItem>(
				backYearPeriod);

		int yearStart = DateTimeUtils.getYear(DateTimeUtils.getCurrentDate());

		for (int i = 0; i <= backYearPeriod; i++) {
			int year = yearStart - i;
			yearPeriods.add(new DictionaryItemBean(String.valueOf(year), String
					.valueOf(year)));
		}

		return yearPeriods;
	}

	public static List<DictionaryItem> getMonths() {

		if (!TypeChecker.isEmpty(MONTHS)) {
			return MONTHS;
		}

		MONTHS = new ArrayList<DictionaryItem>(12);

		for (int i = 1; i <= 12; i++) {

			String month = StringUtils.appendBeforeCharToLength(String
					.valueOf(i), "0", 2);

			MONTHS.add(new DictionaryItemBean(String.valueOf(i), month));
		}

		return MONTHS;

	}

	public static List<String> getTimesPeriod(String start, String end, int step) {
		return getTimesPeriod(start, end, step, true);
	}

	public static List<String> getTimesPeriod(String start, String end,
			int step, boolean twentyFour) {

		Time stTm = Time.valueOf(start + ":00");
		Time edTm = Time.valueOf(end + ":00");

		List<String> times = new ArrayList<String>(15);

		Time tmp = stTm;

		times.add(DateTimeUtils.convertDateToWeb(tmp, DateTimeFormat.HH_MM));

		while (tmp.getTime() < edTm.getTime()) {

			tmp = new Time(DateTimeUtils.addDateByMin(tmp, step).getTime());

			if ("00:00".equalsIgnoreCase(DateTimeUtils.convertDateToWeb(tmp,
					DateTimeFormat.HH_MM))) {
				break;
			}

			times
					.add(DateTimeUtils.convertDateToWeb(tmp,
							DateTimeFormat.HH_MM));
		}

		if ("23:59".equalsIgnoreCase(end) && twentyFour) {

			times.add("24:00");

			return times;

		}

		times.add(DateTimeUtils.convertDateToWeb(edTm, DateTimeFormat.HH_MM));

		return times;

	}

	public static List<Date> getAllDatesBetweenPeriods(Date startDate,
			Date endDate, int step) {

		Date temp = startDate;

		List<Date> dates = new ArrayList<Date>((DateTimeUtils.diffDays(
				startDate, endDate) + 1)
				/ step + 1);

		do {

			dates.add(temp);

			temp = DateTimeUtils.addDateByDay(temp, step);

		} while (temp.getTime() <= endDate.getTime());

		return dates;
	}

	private static List<DictionaryItem> MONTHS = null;

	public static final class DatePeriodType {

		public static final DatePeriodType WEEK_PERIOD = new DatePeriodType(
				"WEEK");

		public static final DatePeriodType MONTH_PERIOD = new DatePeriodType(
				"MONTH");

		private String pattern;

		private DatePeriodType(String pattern) {
			this.pattern = pattern;
		}

		public String getPattern() {
			return pattern;
		}

	}

	public static String getEncyptedCurrentDate(int lapse) {
		return getEncyptedDate(getCurrentDate(), lapse);
	}

	public static String getEncyptedDate(Date date, int lapse) {
		Assert.notNull(date, "The encrypted date must be provided.");
		String encryptedDate = "";
		encryptedDate += getSummaryByAddEachDigial(String.valueOf(DateTimeUtils
				.getYear(date)), lapse);
		encryptedDate += getSummaryByAddEachDigial(String.valueOf(DateTimeUtils
				.getMonth(date)), lapse);
		encryptedDate += getSummaryByAddEachDigial(String.valueOf(DateTimeUtils
				.getDay(date)), lapse);

		return encryptedDate;
	}

	private static int getSummaryByAddEachDigial(String text,
			int additinalQuantity) {

		if (TypeChecker.isEmpty(text)) {
			return 0;
		}
		int summary = additinalQuantity;

		for (int i = 0, j = text.length(); i < j; i++) {
			summary += NumberUtils.parseInt(String.valueOf(text.charAt(i)));
		}

		return summary;
	}

	public static String getTimeTextWithSecond(long sec) {

		String timeText = "";

		int time = 1;

		if (sec >= A_WHOLE_DAY_SEC) {
			time = (int) (sec / A_WHOLE_DAY_SEC);
			timeText += time + "天";
			sec = sec - A_WHOLE_DAY_SEC * time;
		}

		if (sec >= A_HOUR_SEC) {
			time = (int) (sec / A_HOUR_SEC);
			timeText += time + "小时";

			sec = sec - A_HOUR_SEC * time;
		}

		if (sec >= A_MIN_SEC) {

			time = (int) (sec / A_MIN_SEC);

			timeText += time + "分钟";

			sec = sec - A_MIN_SEC * time;
		}

		return sec == 0 ? timeText : timeText + sec + "秒";

	}

	public static DateTimeBean parseDateTimeByFormat(String dateTime,
			String format) {

		DateTimeBean dateTimeBean = parseDateByFormat(dateTime, format);

		if (TypeChecker.isNull(dateTimeBean)) {
			return null;
		}

		if (format.indexOf(" ") < 0) {
			return dateTimeBean;
		}

		DateTimeBean timeBean = parseTimeByFormat(dateTime, format);

		if (TypeChecker.isNull(timeBean)) {
			return null;
		}

		dateTimeBean.setHour(timeBean.hour);
		dateTimeBean.setMinute(timeBean.minute);
		dateTimeBean.setSecond(timeBean.second);

		return dateTimeBean;

	}

	public static DateTimeBean parseTimeByFormat(String dateTime, String format) {

		if (TypeChecker.isEmpty(dateTime) || TypeChecker.isEmpty(format)) {
			return null;
		}

		format = StringUtils.trimToEmpty(format).toLowerCase();

		String[] timeFormats = StringUtils.splitBySeparator(format, " ");

		String timeFormat = timeFormats[timeFormats.length - 1];

		String[] dateTimeArrays = StringUtils.splitBySeparator(dateTime, " ");

		String time = dateTimeArrays[dateTimeArrays.length - 1];

		String[] timeFormatArrays = StringUtils.splitBySeparator(timeFormat,
				":");
		String[] timeArrays = StringUtils.splitBySeparator(time, ":");

		if (timeFormatArrays.length != timeArrays.length) {
			return null;
		}

		DateTimeBean dateTimeBean = new DateTimeBean();

		for (int i = 0; i < timeFormatArrays.length; i++) {

			if ("hh".equalsIgnoreCase(timeFormatArrays[i])) {
				dateTimeBean.setHour(timeArrays[i]);
				continue;
			}

			if ("mm".equalsIgnoreCase(timeFormatArrays[i])) {
				dateTimeBean.setMinute(timeArrays[i]);
				continue;
			}

			if ("ss".equalsIgnoreCase(timeFormatArrays[i])) {
				dateTimeBean.setSecond(timeArrays[i]);
				continue;
			}

			Assert.isTrue(false, "The time format[" + timeFormat
					+ "] must include HH MM and SS!");
		}

		return dateTimeBean;

	}

	public static DateTimeBean parseDateByFormat(String date, String format) {

		date = StringUtils.trimToEmpty(date);

		if (TypeChecker.isEmpty(date) || TypeChecker.isEmpty(format)) {
			return null;
		}

		String dateFormat = StringUtils.splitBySeparator(format, " ")[0];
		date = StringUtils
				.trimToEmpty(StringUtils.splitBySeparator(date, " ")[0]);

		String dateYmdSeparator = getDateYmdSeparator(dateFormat);

		DateTimeBean dateTimeBean = new DateTimeBean();

		// YMD没有分割符号
		if (TypeChecker.isEmpty(dateYmdSeparator)) {

			if (StringUtils.trimToEmpty(dateFormat).length() != "yyyymmdd"
					.length()) {
				return null;
			}

			dateTimeBean.setYear(getLocatedPureYmdValue(date, dateFormat, "y"));
			dateTimeBean
					.setMonth(getLocatedPureYmdValue(date, dateFormat, "m"));
			dateTimeBean.setDay(getLocatedPureYmdValue(date, dateFormat, "d"));

			return dateTimeBean;

		}

		String[] ymdFormatArrays = StringUtils.splitBySeparator(dateFormat,
				dateYmdSeparator);

		String[] ymdValueArrays = StringUtils.splitBySeparator(date,
				dateYmdSeparator);

		// YYYY MM DD 三部分
		if (ymdFormatArrays.length != 3 || ymdValueArrays.length != 3) {
			return null;
		}

		for (int i = 0; i < ymdFormatArrays.length; i++) {

			if ("yyyy".equalsIgnoreCase(ymdFormatArrays[i])) {
				dateTimeBean.setYear(ymdValueArrays[i]);
				continue;
			}

			if ("mm".equalsIgnoreCase(ymdFormatArrays[i])) {
				dateTimeBean.setMonth(ymdValueArrays[i]);
				continue;
			}

			if ("dd".equalsIgnoreCase(ymdFormatArrays[i])) {
				dateTimeBean.setDay(ymdValueArrays[i]);
				continue;
			}

			Assert.isTrue(false, "The date format[" + ymdFormatArrays[0]
					+ "] must include YYYY MM and DD!");
		}

		return dateTimeBean;
	}

	private static String getLocatedPureYmdValue(String date, String format,
			String ymdSelector) {

		format = StringUtils.trimToEmpty(format).toLowerCase();
		ymdSelector = StringUtils.trimToEmpty(ymdSelector).toLowerCase();

		return date.substring(format.indexOf(ymdSelector), format
				.lastIndexOf(ymdSelector) + 1);

	}

	private static String getDateYmdSeparator(String format) {

		format = StringUtils.trimToEmpty(format).toLowerCase();

		format = StringUtils.splitBySeparator(format, " ")[0];

		format = StringUtils.remove(format, "y");
		format = StringUtils.remove(format, "m");
		format = StringUtils.remove(format, "d");

		if (TypeChecker.isEmpty(format)) {
			return "";
		}

		return format.substring(0, 1);

	}

	public static class DateTimeBean {

		private String year;

		private String month;

		private String day;

		private String hour;

		private String minute;

		private String second;

		public DateTimeBean() {

		}

		void setDay(String day) {
			this.day = StringUtils.appendBeforeCharToLength(day, "0", 2);
		}

		void setHour(String hour) {
			this.hour = StringUtils.appendBeforeCharToLength(hour, "0", 2);
		}

		void setMinute(String minute) {
			this.minute = StringUtils.appendBeforeCharToLength(minute, "0", 2);
		}

		void setMonth(String month) {
			this.month = StringUtils.appendBeforeCharToLength(month, "0", 2);
		}

		void setSecond(String second) {
			this.second = StringUtils.appendBeforeCharToLength(second, "0", 2);
		}

		void setYear(String year) {
			this.year = year;
		}

		public String getStandardDate() {
			return "";
		}

		public String getStandardDateTime() {
			return "";
		}

		public String getDateTimeTextByFormat(String format) {

			format = StringUtils.trimToEmpty(format).toLowerCase();

			format = StringUtils.replaceAll(format, "yyyy", this.year);

			format = StringUtils.replaceAll(format, "mm", this.month);
			format = StringUtils.replaceAll(format, "dd", this.day);
			format = StringUtils.replaceAll(format, "hh", this.hour);
			format = StringUtils.replaceAll(format, "mm", this.minute);
			format = StringUtils.replaceAll(format, "ss", this.second);

			return format;

		}

		public String getDay() {
			return day;
		}

		public String getHour() {
			return hour;
		}

		public String getMinute() {
			return minute;
		}

		public String getMonth() {
			return month;
		}

		public String getSecond() {
			return second;
		}

		public String getYear() {
			return year;
		}

	}

	public static final long A_MIN_SEC = 60;

	public static final long A_HOUR_SEC = A_MIN_SEC * 60;

	public static final long A_WHOLE_DAY_SEC = A_HOUR_SEC * 24;

	public static final long A_WHOLE_DAY_MILSEC = 24 * 3600 * 1000;

}
