package com.rapid.j2ee.framework.core.utils;

import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class FileCopyUtils extends org.springframework.util.FileCopyUtils {

	private static final Log logger = LogFactory.getLog(FileCopyUtils.class);

	private FileCopyUtils() {

	}

	public static void copy(RandomAccessFile randomAccess, long skipSize,
			OutputStream os) {

		try {

			randomAccess.seek(skipSize);

			byte[] bytes = new byte[BUFFER_SIZE];

			int readSize = 0;

			while ((readSize = randomAccess.read(bytes)) >= 0) {

				os.write(bytes, 0, readSize);

				os.flush();
			}

			logger.info("FileCopyUtils Copy Completed!");

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {

			try {
				randomAccess.close();
			} catch (Exception e) {

			}

			try {
				os.close();
			} catch (Exception e) {

			}
		}

	}

	public static void copy(File file, long skipSize, OutputStream os) {

		RandomAccessFile raf = null;
		try {

			raf = new RandomAccessFile(file, "r");
			copy(raf, skipSize, os);
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			try {
				raf.close();
			} catch (Exception e) {

			}
		}
	}

}
