package com.rapid.j2ee.framework.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class FileMd5 {

	public static String getMD5(File file) {
		try {
			if (TypeChecker.isNull(file)) {
				return "";
			}
			return getMD5(new FileInputStream(file));
		} catch (FileNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	/**
	 * 对一个Inputstream 获取md5值
	 * 
	 * @return md5串
	 */
	public static String getMD5(InputStream is) {

		try {
			if (TypeChecker.isNull(is)) {
				return "";
			}
			MessageDigest md5 = getMessageDigestMd5();

			byte[] buffer = new byte[8192];
			int length = 0;

			while ((length = is.read(buffer)) != -1) {
				md5.update(buffer, 0, length);
			}

			return new String(Hex.encodeHex(getMessageDigestMd5().digest()));

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);

		} finally {
			try {
				is.close();
			} catch (Exception e) {

			}
		}
	}

	private static MessageDigest getMessageDigestMd5() {

		if (MessageDigest_Md5 == null) {
			try {
				MessageDigest_Md5 = MessageDigest.getInstance("MD5");
			} catch (NoSuchAlgorithmException e) {
				throw ExceptionUtils.convertThrowableToBaseException(e);
			}
		}

		return MessageDigest_Md5;
	}

	private static MessageDigest MessageDigest_Md5 = null;

	/**
	 * 求一个字符串的md5值
	 * 
	 * @param target
	 *            字符串
	 * @return md5 value
	 */
	public static String MD5(String target) {
		return DigestUtils.md5Hex(target);
	}

}
