package com.rapid.j2ee.framework.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

public class HtmlUtils {

	private HtmlUtils() {

	}

	public static String removeHtmlTags(String html, String... tagNames) {

		for (String tagName : tagNames) {
			html = removeHtmlTag(html, tagName);
		}

		return html;
	}

	public static String removeHtmlTag(String html, String tagName) {

		if (TypeChecker.isEmpty(html)) {
			return html;
		}

		Pattern tagNamePattern = Pattern.compile("(<[" + tagName.toLowerCase()
				+ "|" + tagName.toUpperCase() + "].*?>)");

		Matcher matcher = tagNamePattern.matcher(html);

		StringBuffer sb = new StringBuffer(html.length());

		while (matcher.find()) {
			matcher.appendReplacement(sb, "");
		}

		matcher.appendTail(sb);

		html = StringUtils.remove(sb.toString(), ("</" + tagName + ">")
				.toLowerCase());

		return StringUtils.remove(html, ("</" + tagName + ">").toUpperCase());

	}

	public static void main(String[] args) {

		System.out.println(removeHtmlTag("<a href='xx'>@fdsaf</a>", "a"));
	}
}
