package com.rapid.j2ee.framework.core.utils;

import java.lang.reflect.Field;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;

public class HttpRequestToJavaBeanUtils {

	private HttpRequestToJavaBeanUtils() {

	}

	public static <T> T convertBean(HttpServletRequest request, Class<T> clz) {

		Object bean = ConstructorUtils.newInstance(clz);

		for (Enumeration<String> parameterKeys = request.getParameterNames(); parameterKeys
				.hasMoreElements();) {

			String parameterName = parameterKeys.nextElement();

			setFieldValue(bean, parameterName, request
					.getParameterValues(parameterName));

		}

		return (T) bean;
	}

	private static boolean setFieldValue(Object bean, String parameterName,
			String[] parameterValues) {

		Field field = ClassUtils.getFieldByIngoreCaseFieldName(bean.getClass(),
				parameterName);

		if (TypeChecker.isNull(field)) {
			return false;
		}

		if (TypeChecker.isNull(parameterValues)) {
			InvokeUtils.setField(bean, field, parameterValues);
			return true;
		}

		if (field.getType() == String[].class) {
			InvokeUtils.setField(bean, field, parameterValues);
			return true;
		}

		if (field.getType() == Boolean.class
				|| field.getType() == boolean.class) {

			InvokeUtils.setSetterMethodOrField(bean, field, TypeChecker
					.isSpecialTrue(parameterValues[0]));

			return true;
		}

		InvokeUtils.setSetterMethodOrField(bean, field, parameterValues[0]);

		return true;
	}

}
