package com.rapid.j2ee.framework.core.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.imageio.ImageIO;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

public abstract class ImageCompressUtils {

	private static final int IMAGE_BUFFER_SIZE = 1024;

	public static void compress(File file, OutputStream os, int width,
			int height) {
		try {
			compress(new FileInputStream(file), os, width, height);
		} catch (FileNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static void compress(InputStream is, OutputStream os, int width,
			int height) {
		Image image = null;

		BufferedOutputStream bos = null;

		try {

			image = ImageIO.read(is);

			BufferedImage imageBuffer = new BufferedImage(width, height,
					BufferedImage.TYPE_INT_RGB);

			imageBuffer.getGraphics().drawImage(
					image.getScaledInstance(width, height,
							Image.SCALE_AREA_AVERAGING), 0, 0, null);

			bos = new BufferedOutputStream(os, IMAGE_BUFFER_SIZE);

			JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(bos);

			encoder.encode(imageBuffer);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {

			try {
				is.close();
			} catch (Exception e) {

			}

			try {
				bos.flush();
			} catch (Exception e) {

			}

			try {
				bos.close();
			} catch (Exception e) {

			}

			try {
				os.flush();
			} catch (Exception e) {

			}

			try {
				os.close();
			} catch (Exception e) {

			}
		}
	}

	public static void compress(File sourceFile, File compressedFile,
			int width, int height) {
		try {
			
			FileUtils.makeDir(compressedFile.getParentFile());
			
			compress(new FileInputStream(sourceFile), new FileOutputStream(
					compressedFile), width, height);
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static void compress(File sourceFile, OutputStream os,
			double percentage) {
		try {

			if (percentage <= 0.0000001 || percentage > 1) {
				percentage = 1;
			}

			DimensionScale scale = ImageCompressUtils
					.getImageDimension(sourceFile);
			scale.scale(percentage);

			compress(new FileInputStream(sourceFile), os, (int) scale
					.getWidth(), (int) scale.getHeight());
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static File compress(File sourceFile, File compressedFile,
			double percentage) {
		try {

			
			compress(sourceFile, new FileOutputStream(compressedFile),
					percentage);

			return compressedFile;
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static File compressPercentage(File sourceFile, File compressedFile,
			int width, int height) {
		try {

			FileUtils.makeDir(compressedFile.getParentFile());

			compressPercentage(sourceFile,
					new FileOutputStream(compressedFile), width, height);

			return compressedFile;

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static void compressPercentage(File sourceFile, OutputStream os,
			int width, int height) {

		try {

			DimensionScale scale = ImageCompressUtils
					.getImageDimension(sourceFile);

			double rate = Math.min(width / scale.getWidth(), height
					/ scale.getHeight());

			compress(sourceFile, os, rate);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static DimensionScale getImageDimension(File sourceFile) {
		try {
			return getImageDimension(new FileInputStream(sourceFile));
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static DimensionScale getImageDimension(InputStream is) {
		try {
			Image image = ImageIO.read(is);

			return new DimensionScale(image.getWidth(null), image
					.getHeight(null));

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {

			try {
				is.close();
			} catch (Exception e) {

			}
		}
	}

	public static File getFileByAlias(File sourceFile, String appendName) {

		String[] fileNameExt = FileUtils.getFileNameAndExtension(sourceFile
				.getName());

		return new File(sourceFile.getParent(), fileNameExt[0] + appendName
				+ "." + fileNameExt[1]);

	}

	@SuppressWarnings("serial")
	public static class DimensionScale extends Dimension {

		public DimensionScale() {
			super();
		}

		public DimensionScale(Dimension d) {
			super(d.width, d.height);
		}

		public DimensionScale(int width, int height) {
			super(width, height);
		}

		public void scale(double percentage) {
			this.setSize(this.getWidth() * percentage, this.getHeight()
					* percentage);
		}

	}

	public static void main(String[] args) {

		File source = new File(
				"C:\\Users\\Administrator\\Desktop\\Bg\\2.jpg");

		System.out.println(getImageDimension(source));

		ImageCompressUtils.compress(source, getFileByAlias(source,
				"_small1"), 1);

	}

}
