package com.rapid.j2ee.framework.core.utils;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class ImageCropUtils {

	public static boolean cropImage(File srcFile, String srcFileExt,
			File outputFile, int x, int y, int width, int height) {

		FileUtils.makeDir(outputFile.getParentFile());

		OutputStream os = null;

		try {
			os = new FileOutputStream(outputFile);
		} catch (FileNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

		return cropImage(srcFile, srcFileExt, os, x, y, width, height);
	}

	/**
	 * @param srcFile源文件
	 * @param outFile输出文件
	 * @param x坐标
	 * @param y坐标
	 * @param width宽度
	 * @param height高度
	 * @return
	 * @创建日期 2012-8-2
	 * @创建时间 下午02:05:03
	 * @描述 —— 裁剪图片
	 */
	public static boolean cropImage(File srcFile, String srcFileExt,
			OutputStream os, int x, int y, int width, int height) {

		FileInputStream is = null;

		ImageInputStream iis = null;

		try {
			// 如果源图片不存在
			if (!srcFile.exists()) {
				return false;
			}

			// 读取图片文件
			is = new FileInputStream(srcFile);

			// ImageReader声称能够解码指定格式
			Iterator<ImageReader> it = ImageIO
					.getImageReadersByFormatName(srcFileExt);

			if (!it.hasNext()) {
				throw new IllegalArgumentException(
						"Cannot find any available image reader for "
								+ srcFileExt + "!");
			}

			ImageReader reader = it.next();

			// 获取图片流
			iis = ImageIO.createImageInputStream(is);

			// 输入源中的图像将只按顺序读取
			reader.setInput(iis, true);

			// 描述如何对流进行解码
			ImageReadParam param = reader.getDefaultReadParam();

			// 图片裁剪区域
			Rectangle rect = new Rectangle(x, y, width, height);

			// 提供一个 BufferedImage，将其用作解码像素数据的目标
			param.setSourceRegion(rect);

			// 使用所提供的 ImageReadParam 读取通过索引 imageIndex 指定的对象
			BufferedImage bi = reader.read(0, param);

			ImageIO.write(bi, srcFileExt, os);

			return true;

		} catch (Exception e) {

			try {
				is = new FileInputStream(srcFile);
				FileCopyUtils.copy(is, os);
			} catch (Exception e1) {

				e1.printStackTrace();
			}

			e.printStackTrace();

			return false;

		} finally {
			try {
				if (is != null) {
					is.close();
				}
				if (iis != null) {
					iis.close();
				}

				if (os != null) {
					os.flush();
					os.close();
				}
			} catch (Exception e) {

			}
		}
	}

	private ImageCropUtils() {

	}

}
