package com.rapid.j2ee.framework.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.springframework.util.FileCopyUtils;

import sun.misc.BASE64Encoder;

public abstract class ImageToBase64 {

	public static String base64(InputStream imgInputStream) {

		try {

			if (TypeChecker.isNull(imgInputStream)) {
				return "";
			}

			ByteArrayOutputStream byteArray = new ByteArrayOutputStream(
					imgInputStream.available());

			FileCopyUtils.copy(imgInputStream, byteArray);

			return new BASE64Encoder().encode(byteArray.toByteArray());

		} catch (Throwable e) {

			return "";
		} finally {
			try {
				imgInputStream.close();
			} catch (Exception e) {

			}
		}

	}

}