package com.rapid.j2ee.framework.core.utils;

import java.util.List;
import java.util.Map;

import com.rapid.j2ee.framework.core.collections.SortHashMap;
import com.rapid.j2ee.framework.core.utils.support.Callable;

public final class MapUtils {

	public static SortHashMap splitSortHashMapByGroupKey(String taget,
			String groupReference, String keyReference) {
		return StringUtils.splitSortHashMapByGroupKey(taget, groupReference,
				keyReference, Callable.NONE);
	}

	public static SortHashMap splitSortHashMapByUpperCaseGroupKey(String taget,
			String groupReference, String keyReference) {
		return StringUtils.splitSortHashMapByGroupKey(taget, groupReference,
				keyReference, Callable.UPPERCASE);
	}

	public static <K, V> Map<K, V> resolveMap(Map<K, V> map,
			List<Callable<V>> callables, Object... arguments) {

		if (TypeChecker.isEmpty(map)) {
			return map;
		}

		for (K key : map.keySet()) {

			V value = map.get(key);

			for (Callable<V> callable : callables) {
				value = callable.call(value, arguments);
			}

			map.put(key, value);

		}

		return map;
	}

	public static Object getValueByIngoreCaseKey(Map<String, ?> map, String key) {

		if (map.containsKey(key)) {
			return map.get(key);
		}

		if (map.containsKey(key.toUpperCase())) {
			return map.get(key.toUpperCase());
		}

		if (map.containsKey(key.toLowerCase())) {
			return map.get(key.toLowerCase());
		}

		for (String mapKey : map.keySet()) {
			if (StringUtils.equalsIgnoreCase(mapKey, key)) {
				return map.get(mapKey);
			}
		}

		return null;

	}

	public static void putValueByIngoreCaseKey(Map map, String key, Object value) {

		for (Object mapKey : map.keySet()) {
			if (StringUtils.equalsIgnoreCase((String) mapKey, key)) {
				map.put(mapKey, value);
			}
		}

	}

	public static boolean containsKey(Map<String, ?> map, String key) {

		if (map.containsKey(key)) {
			return true;
		}

		if (map.containsKey(key.toUpperCase())) {
			return true;
		}

		if (map.containsKey(key.toLowerCase())) {
			return true;
		}

		for (String mapKey : map.keySet()) {
			if (StringUtils.equalsIgnoreCase(mapKey, key)) {
				return true;
			}
		}

		return false;

	}

	private MapUtils() {

	}
}
