package com.rapid.j2ee.framework.core.utils;

import java.util.Collection;

public final class MathUtils {

	private MathUtils() {

	}

	public static int sumInteger(String value1, String value2) {
		return NumberUtils.parseInt(value1) + NumberUtils.parseInt(value2);
	}

	public static double sumDouble(String value1, String value2) {
		return NumberUtils.parseDouble(value1)
				+ NumberUtils.parseDouble(value2);
	}

	public static <T> T calcuate(Collection<T> items, Calculator<T> summary) {

		if (TypeChecker.isEmpty(items)) {
			return (T) summary;
		}

		for (T item : items) {

			if (summary == item) {
				continue;
			}
			summary.calcuate(item);
		}
		return (T) summary;
	}

	public static void calcuate(Collection items, Calculatable calcuatable) {

		if (TypeChecker.isEmpty(items)) {
			return;
		}

		for (Object item : items) {

			calcuatable.calcuate(item);
		}

	}

	public interface Calculator<T> {

		public void calcuate(T item);
	}

	public interface Calculatable<T> {

		public void calcuate(T item);
	}

}
