package com.rapid.j2ee.framework.core.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessagetFormatUtils {

	private MessagetFormatUtils() {

	}

	public static boolean containsDynamicKey(String message) {
		return StringUtils.contains(message, "{")
				&& StringUtils.contains(message, "}");
	}
	public static String formatAsNameKeysArguments(String message,
			Map<String, ?> arguments, Locale locale) {

		String[] dynamicMessages = StringUtils.splitRestrictClosure(message,
				"{", "}");

		if (TypeChecker.isEmpty(dynamicMessages)) {
			return message;
		}

		List argumentValues = new ArrayList(dynamicMessages.length);

		for (int i = 0; i < dynamicMessages.length; i++) {

			String dynamicKey = StringUtils.substringBefore(dynamicMessages[i],
					",");

			message = StringUtils.replaceOnce(message, "{" + dynamicKey, "{"
					+ String.valueOf(argumentValues.size()));

			argumentValues.add(arguments.get(dynamicKey));

		}

		return StringUtils.remove(new MessageFormat("", locale).format(message,
				argumentValues.toArray(new Object[argumentValues.size()])),
				"null", "()", "[]");

	}

	public static void main(String[] args) {

		System.out
				.println(MessagetFormatUtils
						.formatAsNameKeysArguments(
								"oh, {personName} {personNam1e} is a person! Hello  {personName}",
								Collections.singletonMap("personName",
										"John Hao"), Locale.CHINA));
	}

}
