package com.rapid.j2ee.framework.core.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;



public final class NumberUtils {

	public static long parseLong(String value) {
		return parseLong(value, 0);
	}

	public static long parseLong(String value, long def) {
		try {
			if (TypeChecker.isEmpty(value)) {
				return def;
			}

			return Long.parseLong(StringUtils.trimToEmpty(value));
		} catch (Exception ex) {
			return def;
		}

	}

	public static int parseInt(String value) {
		return parseInt(value, 0);
	}

	public static int parseInt(String value, int def) {
		try {
			if (TypeChecker.isEmpty(value)) {
				return def;
			}

			return Integer.parseInt(StringUtils.trimToEmpty(value));
		} catch (Exception ex) {
			return def;
		}

	}

	public static double parseDouble(String value, double def) {
		try {

			if (TypeChecker.isEmpty(value)) {
				return def;
			}

			return Double.parseDouble(StringUtils.trimToEmpty(value));
		} catch (Exception ex) {
			return def;
		}
	}

	public static double parseDouble(String value) {
		return parseDouble(value, 0.0);
	}

	public static double parsePercent(String value) {
		return parsePercent(value, 0.0);
	}

	public static double parsePercent(String value, double def) {
		try {
			double divideNumber = 1.0;
			if (value.endsWith("%")) {
				value = StringUtils.replace(value, "%", "");
				divideNumber = 100.0;
			}
			return parseDouble(value, def) / divideNumber;
		} catch (Exception ex) {
			return def;
		}
	}

	public static BigDecimal parseBigDecimal(String value, String defBigDec) {
		try {
			if (!TypeChecker.isBlueNumber(value)) {
				return new BigDecimal(defBigDec);
			}
			return new BigDecimal(value);
		} catch (Exception ex) {
			return new BigDecimal(defBigDec);
		}
	}

	public static synchronized String formatCurrency(Object value) {
		return formatNumber(DECIMAL_FORMAT, value);
	}

	public static String formatCurrencyWithUnit(Object value, Locale l) {
		if (!TypeChecker.isBlueNumber(value)) {
			return StringUtils.trimToEmpty(String.valueOf(value));
		}

		Double doubleValue = convertAnyToDouble(value);

		if (TypeChecker.isNull(doubleValue)
				|| doubleValue.doubleValue() == Double.MAX_VALUE
				|| doubleValue.doubleValue() == Double.MIN_VALUE) {
			return "";
		}

		return NumberFormat.getCurrencyInstance(l).format(doubleValue);
	}

	public static String formatCurrencyWithUnit(Object value) {
		return formatCurrencyWithUnit(value, Locale.CHINA);
	}

	public static synchronized String formatInteger(Object value) {
		return formatNumber(NUMBER_FORMAT, value);
	}

	public static synchronized String formatPercent(Object value) {
		return formatNumber(PERCENT_FORMAT, value);
	}

	public static final String DECIMAL_FORMAT = "#,##0.00;-#,##0.00";

	public static final String PERCENT_FORMAT = "#,##0.00;-#,##0.00";

	public static final String NUMBER_FORMAT = "#,##0;-#,##0";

	public static synchronized String formatNumber(String pattern, Object value) {

		if (!TypeChecker.isBlueNumber(value)) {
			return StringUtils.trimToEmpty(String.valueOf(value));
		}
		Double doubleValue = convertAnyToDouble(value);

		if (TypeChecker.isNull(doubleValue)
				|| doubleValue.doubleValue() == Double.MAX_VALUE
				|| doubleValue.doubleValue() == Double.MIN_VALUE) {
			return "";
		}

		NumberFormat nf = getNumberFormatByPattern(pattern);

		return nf.format(round(doubleValue.doubleValue(), nf));

	}

	public static Double convertAnyToDouble(Object value) {
		try {
			if (TypeChecker.isNull(value)) {
				return null;
			}

			if (!TypeChecker.isBlueNumber(value)) {
				return null;
			}

			if (value instanceof Double) {
				return (Double) value;
			}

			if (value instanceof String && TypeChecker.isEmpty((String) value)) {
				return null;
			}

			return Double.valueOf(String.valueOf(value));
		} catch (Exception ep) {
			return null;
		}

	}

	public static NumberFormat getNumberFormatByPattern(String pattern) {

		if (!NUMBER_FORMAT_INSTANCE_MAP.containsKey(pattern)) {
			NUMBER_FORMAT_INSTANCE_MAP.put(pattern, new DecimalFormat(pattern));
		}

		return NUMBER_FORMAT_INSTANCE_MAP.get(pattern);

	}

	private static final Map<String, NumberFormat> NUMBER_FORMAT_INSTANCE_MAP = new HashMap<String, NumberFormat>(
			5);

	public static double round(double d, NumberFormat nf) {

		return round(d, nf.getMaximumFractionDigits());
	}

	public static double round(double d, int scale) {

		BigDecimal big = new BigDecimal(d);

		big = big.setScale(scale, BigDecimal.ROUND_HALF_UP);

		return big.doubleValue();
	}

	public static int ceil(int value, int divide) {
		if (divide == 0) {
			return value;
		}

		return value % divide == 0 ? value / divide
				: ((int) value / divide) + 1;
	}

	public static Number toNumber(Object object) {

		if (TypeChecker.isNull(object)) {
			return null;
		}

		if (object instanceof Number) {
			return ((Number) object);
		}

		return Double.valueOf(String.valueOf(object));

	}

	private NumberUtils() {

	}

	public static void main(String[] args) {
		System.out.println(NumberUtils.ceil(9, 3));
	}
}
