package com.rapid.j2ee.framework.core.utils;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.collections.MultiHashMap;

import com.rapid.j2ee.framework.core.collections.EmptyMultiHashMap;
import com.rapid.j2ee.framework.core.collections.EmptySortHashMap;
import com.rapid.j2ee.framework.core.collections.SortHashMap;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.support.ObjectResolvable;

public final class ObjectUtils extends org.springframework.util.ObjectUtils {

	public static final String[] EMPTY_STRING_ARRAYS = new String[0];

	public static final Object[] EMPTY_OBJECT_ARRAYS = new Object[0];

	public static final Class[] EMPTY_CLASS_ARRAYS = new Class[0];

	public static final byte[] EMPTY_BYTE_ARRAYS = new byte[0];

	public static final File[] EMPTY_FILE_ARRAYS = new File[0];

	public static final int[] EMPTY_INT_ARRAYS = new int[0];

	public static final Map EMPTY_MAP = Collections.EMPTY_MAP;

	public static final List EMPTY_LIST = Collections.EMPTY_LIST;

	public static final Set EMPTY_SET = Collections.EMPTY_SET;

	public static final SortHashMap EMPTY_SORTHASHMAP = new EmptySortHashMap();

	public static final Properties EMTPY_PROPERTIES = new Properties();

	public static final MultiHashMap EMPTY_MULTIHASHMAP = new EmptyMultiHashMap();

	public static final List<Class> WIDE_PRIMITIVE_CLASSES = new ArrayList<Class>();

	public static final Map<Class, Number> WIDE_BASIC_NUMBER_CLASSES = new HashMap<Class, Number>();

	static {

		WIDE_PRIMITIVE_CLASSES.add(Date.class);
		WIDE_PRIMITIVE_CLASSES.add(String.class);
		WIDE_PRIMITIVE_CLASSES.add(Number.class);
		WIDE_PRIMITIVE_CLASSES.add(BigDecimal.class);
		WIDE_PRIMITIVE_CLASSES.add(Timestamp.class);
		WIDE_PRIMITIVE_CLASSES.add(Time.class);
		WIDE_PRIMITIVE_CLASSES.add(Integer.class);
		WIDE_PRIMITIVE_CLASSES.add(Float.class);
		WIDE_PRIMITIVE_CLASSES.add(Long.class);
		WIDE_PRIMITIVE_CLASSES.add(Double.class);

		WIDE_BASIC_NUMBER_CLASSES.put(int.class, 0);
		WIDE_BASIC_NUMBER_CLASSES.put(double.class, 0);
		WIDE_BASIC_NUMBER_CLASSES.put(byte.class, 0);
		WIDE_BASIC_NUMBER_CLASSES.put(long.class, 0);
		WIDE_BASIC_NUMBER_CLASSES.put(float.class, 0);
	}

	private ObjectUtils() {

	}

	public static Class[] getClassArrays(Class... classes) {

		return classes;
	}

	public static boolean isWidePrimitive(Class clz) {
		return clz.isPrimitive() || WIDE_PRIMITIVE_CLASSES.contains(clz);
	}

	public static Object cloneObject(Object serializable) {
		return StreamIoUtils.readObject(StreamIoUtils
				.getObjectInputStream(serializable));
	}

	public static List getFieldValuesByName(Collection coll,
			ObjectResolvable resolver, String... fieldNames) {

		if (TypeChecker.isEmpty(coll)) {
			return ObjectUtils.EMPTY_LIST;
		}

		List fieldValues = new ArrayList(coll.size());

		for (Object obj : coll) {
			for (String fieldName : fieldNames) {
				fieldValues.add(resolver.resolve(BeanUtils.getPropertyObject(
						obj, fieldName)));
			}
		}

		return fieldValues;
	}

	public static List getFieldValuesByName(Collection coll,
			String... fieldNames) {
		return getFieldValuesByName(coll, ObjectResolvable.Nothing_Resolver,
				fieldNames);
	}

	public static Map<String, ?> convertBeanFieldValueMapWithFlagFix(
			String prefix, String subfix, Object... values) {

		prefix = StringUtils.trimToEmpty(prefix);
		subfix = StringUtils.trimToEmpty(subfix);

		Map<String, Object> valueFieldMap = new HashMap(25);

		if (TypeChecker.isEmpty(values)) {
			return valueFieldMap;
		}

		for (Object value : values) {

			if (TypeChecker.isNull(value)) {
				continue;
			}

			for (Field field : ClassUtils.getAllFieldsAsClass(value.getClass())) {

				if (field.getName().equalsIgnoreCase("serialVersionUID")) {
					continue;
				}

				Object fieldValue = InvokeUtils.getFieldValue(value, field);

				if (TypeChecker.isNull(fieldValue)) {
					continue;
				}

				valueFieldMap
						.put(prefix + field.getName() + subfix, fieldValue);
			}

		}

		return valueFieldMap;

	}

	public static Map<String, ?> convertBeanFieldValueMap(Object... values) {

		return convertBeanFieldValueMapWithFlagFix("", "", values);
	}

	public static void removeObjectBeanFieldValues(Object target,
			String... fieldNames) {

		for (String fieldName : fieldNames) {
			BeanUtils.setProperty(target, fieldName, null);
		}
	}

	public static String getCachedKey(Object paramters) {
		return ObjectAnalyzer.toString(paramters);
	}

	public static Object getPrimitiveNullValue(Class clz) {

		if (WIDE_BASIC_NUMBER_CLASSES.containsKey(clz)) {
			return WIDE_BASIC_NUMBER_CLASSES.get(clz);
		}

		return null;
	}

	public static boolean isBasicPrimitiveType(Class clz) {
		return WIDE_BASIC_NUMBER_CLASSES.containsKey(clz);
	}

	public static Object getPrimitiveValue(Class clz, Object value) {
		if (clz == int.class || clz == Integer.class) {
			return new Integer(NumberUtils.parseInt(String.valueOf(value)));
		}

		if (clz == long.class || clz == Long.class) {
			return new Long(NumberUtils.parseLong(String.valueOf(value)));
		}

		if (clz == float.class || clz == Float.class) {
			return new Float(NumberUtils.parseDouble(String.valueOf(value)));
		}

		if (clz == double.class || clz == Double.class) {
			return new Double(NumberUtils.parseDouble(String.valueOf(value)));
		}

		throw new IllegalArgumentException("Class type == " + clz.getName());
	}

}
