package com.rapid.j2ee.framework.core.utils;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

/**
 * PII Mask 数据
 * 
 * @author John Hao
 * 
 */
public class PIIMaskUtils {

	/**
	 * 格式化保单号, 隐藏倒数8-5位
	 * 
	 * @param policyNo
	 * @return
	 */
	public static String maskPolicyNo(String policyNo) {

		if (TypeChecker.isEmpty(policyNo) || policyNo.length() < 8) {

			return StringUtils.trimToEmpty(policyNo);
		}

		int start = policyNo.length() - 8;

		return maskString(policyNo, start, 4);

	}

	/**
	 * 格式化姓名, 隐藏最后一位
	 * 
	 * @param name
	 * @return
	 */
	public static String maskPersonName(String name) {
		if (TypeChecker.isEmpty(name) || name.length() < 2) {
			return StringUtils.trimToEmpty(name);
		}

		int start = name.length() - 1;

		return maskString(name, start, 1);
	}

	/**
	 * 格式化手机号码
	 * 
	 * @param mobile
	 * @return
	 */
	public static String maskMobile(String mobile) {

		if (TypeChecker.isEmpty(mobile) || mobile.length() < 7) {
			return StringUtils.trimToEmpty(mobile);
		}

		return maskString(mobile, 3, (mobile.length() + 1) / 3);
	}

	/**
	 * 格式化字符串-隐藏中间几位
	 * 
	 * @param str
	 *            字符串
	 * @param start
	 *            开始下标
	 * @param count
	 *            隐藏位数
	 * @param replacement
	 *            替换字符
	 * @return
	 */
	public static String maskString(String str, int start, int count,
			String replacements) {

		return str.replaceAll(getFormatRegex(start, count),
				getReplacementRegex(replacements));
	}

	/**
	 * 格式化字符串-隐藏中间几位
	 * 
	 * @param str
	 *            字符串
	 * @param start
	 *            开始下标
	 * @param count
	 *            隐藏位数
	 * @param replacement
	 *            替换字符
	 * @return
	 */
	public static String maskString(String str, int start, int count,
			char replacement) {

		return maskString(str, start, count,
				getReplacements(replacement, count));
	}

	/**
	 * 格式化字符串-隐藏中间几位
	 * 
	 * @param str
	 *            字符串
	 * @param start
	 *            开始下标
	 * @param count
	 *            隐藏位数
	 * @param replacement
	 *            替换字符
	 * @return
	 */
	public static String maskString(String str, int start, int count) {

		return maskString(str, start, count, REPLACEMENT_DEF);
	}

	/**
	 * 获取替换正则表达式
	 * 
	 * @param start
	 *            开始位数
	 * @param count
	 *            替换位数
	 * @return
	 */
	private static String getFormatRegex(int start, int count) {
		return "^(\\S{" + start + "})\\S{" + count + "}(\\S*)$";
	}

	/**
	 * 获取替换的字符串正则
	 * 
	 * @param replacements
	 * @return
	 */
	private static String getReplacementRegex(String replacements) {
		return "$1" + replacements + "$2";
	}

	/**
	 * 获取替换的字符串
	 * 
	 * @param replacememt
	 *            替换字符
	 * @param count
	 *            字符个数
	 * @return
	 */
	private static String getReplacements(char replacement, int count) {

		String replacements = replacement + "";

		for (int i = 1; i < count; i++) {
			replacements += replacement;
		}

		return replacements;
	}

	private PIIMaskUtils() {

	}

	public static void main(String[] args) {

		System.out.println(PIIMaskUtils.maskMobile("12"));
	}

	public static final char REPLACEMENT_DEF = '*';

}
