package com.rapid.j2ee.framework.core.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import org.springframework.core.io.ClassPathResource;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;

public final class PropertiesUtils {

	private PropertiesUtils() {

	}

	public static Properties revise(Properties prop) {
		
		if (TypeChecker.isEmpty(prop)) {
			return prop;
		}

		Properties reviseProp = new Properties();

		for (Object key : prop.keySet()) {
			reviseProp.put(prop.get(key), key);
		}
		
		return reviseProp;
	}

	public static Properties getProperties(String classPath, boolean ignoreCase) {
		return getProperties(classPath, ignoreCase, true);
	}

	public static Properties getProperties(String classPath,
			boolean ignoreCase, boolean ignoreExp) {
		return getProperties(classPath, Charsets
				.getCharsetInstance(CharsetType.UTF_8), ignoreCase, ignoreExp);
	}

	public static Properties getProperties(String classPath, Charset charset,
			boolean ignoreCase) {
		return getProperties(classPath, charset, ignoreCase, true);
	}

	public static Properties getProperties(String classPath, Charset charset,
			boolean ignoreCase, boolean ignoreExp) {

		PropertiesImp props = new PropertiesImp(ignoreCase);

		try {
			props.loadResource(new ClassPathResource(classPath)
					.getInputStream(), charset);

		} catch (Exception e) {

			try {
				props.loadResource(new FileInputStream(classPath), charset);
			} catch (Exception e1) {

				if (!ignoreExp) {
					throw new SystemException(
							"The properties resouce [ "
									+ classPath
									+ " ] cannot be loaded in the current class loader.",
							e);
				}
			}

		}

		return props;
	}

	public static Properties newProperties(InputStream is, Charset charset,
			boolean ignoreCase) {
		try {
			return new PropertiesImp(ignoreCase).loadResource(is, charset);
		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			try {
				is.close();
			} catch (Exception e) {

			}
		}
	}

	public static Properties newProperties(InputStream is, Charset charset) {
		return newProperties(is, charset, false);
	}

	public static void main(String[] args) {

	}

	static class PropertiesImp extends Properties {

		private static final long serialVersionUID = 1L;

		private boolean ignoreCase = false;

		public PropertiesImp(boolean ignoreCase) {
			this.ignoreCase = ignoreCase;
		}

		public PropertiesImp() {
			ignoreCase = false;
		}

		public Properties loadResource(InputStream is, Charset charset)
				throws IOException {

			try {

				if (TypeChecker.isNull(charset)) {
					charset = Charsets.getCharsetInstance(CharsetType.ENGLISH);
				}

				super.load(new InputStreamReader(is, charset.getCharset()));

				// Process Shared Name...

				return this;

			} finally {

				try {
					is.close();
				} catch (Exception e) {

				}
			}
		}

		@Override
		public Object put(Object key, Object value) {
			if (ignoreCase) {
				if (key instanceof String && value instanceof String) {
					key = ((String) key).toLowerCase();
				}
			}

			return super.put(key, value);
		}

		@Override
		public String getProperty(String key) {

			if (ignoreCase) {

				key = ((String) key).toLowerCase();

			}

			return super.getProperty(key);
		}

	}

}
