package com.rapid.j2ee.framework.core.utils;

import java.util.Random;

public class RandomUtils {

	public static void main(String[] args) {
		System.out.println(nextRandomNumber(10));
		System.out.println(nextAlphabetLetter(10));
		System.out.println(nextAlphabetNumberLetter(10));

	}

	public static String nextRandomNumber(int length) {
		return nextRandomText(Number_Codes, length);
	}

	public static String nextAlphabetLetter(int length) {
		return nextRandomText(Alphabet_Upper_Lower_Letter_Codes, length);
	}

	public static String nextAlphabetNumberLetter(int length) {
		return nextRandomText(Alphabet_Number_Letter_Codes, length);
	}
	
	public static String nextVerificationLetter(int length) {
		return nextRandomText(Verification_Letter_Codes, length);
	}

	public static String nextRandomText(String randomSource, int length) {

		StringBuffer randomValues = new StringBuffer(length);

		while (randomValues.length() < length) {
			randomValues.append(next(randomSource));
		}

		return randomValues.toString();
	}

	private synchronized static String next(String text) {

		return String.valueOf(text.charAt(Random.nextInt(text.length())));
	}
	
	public static int randomRange(int range){
		return Random.nextInt(range);
	}

	private RandomUtils() {

	}

	private static Random Random = new Random(System.currentTimeMillis());

	private static final String Number_Codes = "01234567890123456789";

	private static final String Alphabet_Upper_Letter_Codes = "ABCDEFGHIJKLMNOPQRSTUYWXYZ";

	private static final String Alphabet_Lower_Letter_Codes = Alphabet_Upper_Letter_Codes
			.toLowerCase();

	private static final String Alphabet_Upper_Lower_Letter_Codes = Alphabet_Upper_Letter_Codes
			+ Alphabet_Lower_Letter_Codes;

	private static final String Alphabet_Number_Letter_Codes = Number_Codes
			+ Alphabet_Upper_Letter_Codes + Number_Codes
			+ Alphabet_Lower_Letter_Codes + Number_Codes;

	private static final String Verification_Letter_Codes = StringUtils.remove(
			Alphabet_Number_Letter_Codes, "I", "L", "l", "o", "O");

}
