package com.rapid.j2ee.framework.core.utils;

import java.lang.reflect.Field;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;

public class RequestUtils {

	public static HttpSession getHttpSession(HttpServletRequest request) {

		HttpSession session = request.getSession(false);

		if (TypeChecker.isNull(session)) {
			session = request.getSession(true);
		}

		return session;
	}
	


	public static void setSessionMaxInactiveInterval(
			HttpServletRequest request, int timeoutSec) {

		getHttpSession(request).setMaxInactiveInterval(timeoutSec);
	}

	public static <T> T convertBean(HttpServletRequest request, Class<T> clz) {

		Object bean = ConstructorUtils.newInstance(clz);

		for (Enumeration<String> parameterKeys = request.getParameterNames(); parameterKeys
				.hasMoreElements();) {

			String parameterName = parameterKeys.nextElement();

			setFieldValue(bean, parameterName, request
					.getParameterValues(parameterName));

		}

		return (T) bean;
	}

	private static boolean setFieldValue(Object bean, String parameterName,
			String[] parameterValues) {

		Field field = ClassUtils.getFieldByIngoreCaseFieldName(bean.getClass(),
				parameterName);

		if (TypeChecker.isNull(field)) {
			return false;
		}

		if (TypeChecker.isNull(parameterValues)) {
			InvokeUtils.setField(bean, field, parameterValues);
			return true;
		}

		if (field.getType() == String[].class) {
			InvokeUtils.setField(bean, field, parameterValues);
			return true;
		}

		if (field.getType() == boolean.class
				|| field.getType() == Boolean.class) {
			InvokeUtils.setField(bean, field, TypeChecker
					.isSpecialTrue(parameterValues[0]));
			return true;
		}

		InvokeUtils.setField(bean, field, parameterValues[0]);

		return true;
	}

	public static String getRequestUrl(HttpServletRequest request) {

		StringBuffer requestUrl = new StringBuffer(500);

		requestUrl.append(request.getQueryString());
		requestUrl.append("?");

		for (Object key : request.getParameterMap().keySet()) {
			for (String value : request.getParameterValues((String) key)) {
				requestUrl.append(key + "=" + value + "&");
			}
		}

		requestUrl.append("1=1");

		return requestUrl.toString();
	}

	private RequestUtils() {

	}

}
