package com.rapid.j2ee.framework.core.utils;

import java.util.HashSet;
import java.util.Set;

public class ResolverUtils {

	private ResolverUtils() {

	}

	public static Set<Class> findImplementations(Class parent,
			String... packages) {
		Set<Class> sets = new _ResolverUtil().findImplementations(parent,
				packages).getClasses();

		Set<Class> implementClasses = new HashSet<Class>(sets.size());

		for (Class clz : sets) {
			if (!ClassUtils.isImplementedClass(clz)) {
				continue;
			}

			implementClasses.add(clz);
		}

		return implementClasses;
	}

	public static Set<Class> findAnnotationMark(final Class annotationClass,
			final String... packages) {

		Set<Class> sets = new HashSet<Class>();

		for (String packageName : packages) {

			sets.addAll(new _ResolverUtil().find(new _ResolverUtil.Test() {

				public boolean matches(Class<?> type) {

					return !TypeChecker.isNull(type
							.getAnnotation(annotationClass));
				}
			}, packageName).getClasses());
		}

		return sets;

	}

}
