package com.rapid.j2ee.framework.core.utils;

import java.util.List;

public enum ResourceType {

	Image("IMAGE", "gif,png,bmp,tif,jpg,ico"), File("FILE", "All");

	private ResourceType(String type, String extension) {
		this.type = type;
		this.extension = extension;
	}

	private String type;

	private String extension;

	public static ResourceType getResourceTypeByExt(String ext) {

		List<ResourceType> resourceTypes = (List<ResourceType>) CONSTANTS
				.getFieldCache().values();

		for (ResourceType resourceType : resourceTypes) {

			if (StringUtils.containsIgnoreCase(resourceType.getExtension(),
					ext, ",")) {
				return resourceType;
			}
		}

		return File;

	}

	public String getExtension() {
		return extension;
	}

	public String getType() {
		return type;
	}

	private static final Constants<ResourceType> CONSTANTS = new Constants<ResourceType>(
			ResourceType.class);
}
