package com.rapid.j2ee.framework.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public final class ResourceUtils {

	public static Resource getResource(String location) {

		return getResources(location)[0];
	}

	public static Resource[] getResources(String location) {
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		try {
			return resolver.getResources(location);
		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public static Resource[] getResources(String[] locations) {

		List<Resource> resourceList = new ArrayList<Resource>(
				locations.length * 3);

		for (String location : locations) {

			Resource[] resources = getResources(location);

			if (TypeChecker.isEmpty(resources)) {
				continue;
			}

			resourceList.addAll(Arrays.asList(resources));
		}

		return resourceList.toArray(new Resource[resourceList.size()]);

	}

	private ResourceUtils() {
		
	}

}
