package com.rapid.j2ee.framework.core.utils;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.util.FileCopyUtils;

import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class ResponseUtils {

	public static void setNoCacheResponse(HttpServletResponse response) {

		response.reset();
		response.setHeader("Pragma", "no-cache");
		response.addHeader("Cache-Control", "must-revalidate");
		response.addHeader("Cache-Control", "no-cache");
		response.addHeader("Cache-Control", "no-store");
		response.setDateHeader("Expires", 0);
	}

	public static void write(String contextType, String charset,
			String context, HttpServletResponse response) {

		try {

			setNoCacheResponse(response);

			response.setContentType(contextType + "; charset=" + charset);

			Writer writer = response.getWriter();
			writer.write(StringUtils.trimToEmpty(context));
			writer.flush();
			writer.close();

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public static void write(String contextType, String fileName, byte[] data,
			String charsetType, HttpServletRequest request,
			HttpServletResponse response) {

		if (TypeChecker.isNull(data)) {
			return;
		}

		OutputStream os = null;

		try {

			response.reset();

			response.setContentType(contextType);

			response.setHeader("Content-disposition", "attachment;filename="
					+ ResponseUtils.getResolvedFileName(request, fileName,
							charsetType));

			response.setContentLength(data.length);

			os = response.getOutputStream();

			FileCopyUtils.copy(data, os);

			data = null;

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			try {
				os.close();
			} catch (Exception e) {

			}
		}
	}

	public static String getResolvedFileName(HttpServletRequest request,
			String fileName, String charsetType) {

		if (request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0) {
			try {

				return StringUtils.replace(
						URLEncoder.encode(fileName, "UTF-8"), "+", "");
			} catch (Throwable e) {

				return fileName;
			}
		}

		return Charsets.getCharsetEncodeInstance(charsetType).toIso8859(
				fileName);
	}

	public static void writeJson(String charset, String context,
			HttpServletResponse response) {
		write("application/json", charset, context, response);
	}

	private ResponseUtils() {

	}

}
