package com.rapid.j2ee.framework.core.utils;

import org.springframework.util.Assert;

public enum StatusTypes {

	Active("A", "Active"), Terminated("T", "Termiate"), Delete("D", "Delete"), Prepared(
			"P", "Prepared"), Finished("F", "Finished"), Cancel("C", "Cancel"), Scheduled(
			"S", "Scheduled"), Assign("A", "Assign"), Add("A", "Add"), Yes("Y",
			"Yes"), No("N", "No"), Published("P", "Published"), Handling("H",
			"Handling"), Error("E", "Error"), Locked("L", "Locked"), Pending(
			"P", "Pending"), UnReaded("UR", "Unreaded"), Readed("RD", "Readed"), Upgraded(
			"U", "Upgraded");

	private String code;

	private String description;

	private StatusTypes(String code, String description) {
		this.code = code;
		this.description = description;
	}

	public String getCode() {
		return code;
	}

	public String getDescription() {
		return description;
	}

	@Override
	public String toString() {

		return "Code:" + code + " Description:" + this.description;
	}

	public static StatusTypes getStatusTypesByEnumName(String name) {
		StatusTypes status = (StatusTypes) statusTypeConstant.getFieldCache()
				.get(StringUtils.trimToEmpty(name).toUpperCase());
		Assert.notNull(status, "Sorry, cannot get a status name by " + name);
		return status;
	}

	private static Constants statusTypeConstant = new Constants(
			StatusTypes.class, true);

	public static void main(String[] args) {

		System.out.println(StatusTypes.getStatusTypesByEnumName("add"));
	}

}
