package com.rapid.j2ee.framework.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import org.springframework.util.FileCopyUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.StreamReaderObjectParseSystemException;

public class StreamIoUtils {

	private StreamIoUtils() {

	}

	public static InputStream getObjectInputStream(Object obj) {

		return new ByteArrayInputStream(getObjectToBytes(obj));

	}

	public static byte[] getObjectToBytes(Object obj) {
		try {
			if (TypeChecker.isNull(obj)) {
				return null;
			}

			ByteArrayOutputStream baos = new ByteArrayOutputStream(500);
			ObjectOutputStream oos = new ObjectOutputStream(baos);
			oos.writeObject(obj);
			close(baos);
			close(oos);

			return baos.toByteArray();

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	/**
	 * Read a object from a native byte file.
	 * 
	 * String InputStream -- a file InputStream
	 */
	public static Object readObject(byte[] bs) {

		return readObject(new ByteArrayInputStream(bs));

	}

	/**
	 * Read a object from a native byte file.
	 * 
	 * String InputStream -- a file InputStream
	 */
	public static Object readObject(InputStream is) {
		ObjectInputStream ois = null;
		try {
			if (TypeChecker.isNull(is)) {
				return null;
			}

			ois = new ObjectInputStream(is);
			return ois.readObject();
		} catch (Throwable e) {
			throw new StreamReaderObjectParseSystemException(e);
		} finally {
			close(ois);
			close(is);
		}

	}

	/**
	 * Close inputSteam.
	 */
	public static void close(InputStream is) {
		try {
			is.close();
		} catch (Exception ep) {
		}
	}

	/**
	 * Close OutputStream.
	 */
	public static void close(OutputStream os) {
		try {
			os.flush();
		} catch (Exception ep) {
		}
		try {
			os.close();
		} catch (Exception ep) {
		}
	}

	public static byte[] zip(byte[] data) {

		if (TypeChecker.isNull(data)) {
			return data;
		}

		try {
			ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
			ZipOutputStream zip = new ZipOutputStream(bos);
			ZipEntry entry = new ZipEntry("zip");
			entry.setSize(data.length);
			zip.putNextEntry(entry);
			zip.write(data);
			zip.closeEntry();
			zip.close();
			byte[] bs = bos.toByteArray();
			bos.close();

			return bs;

		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static byte[] unZip(byte[] data) {
		if (TypeChecker.isNull(data)) {
			return data;
		}

		try {
			ByteArrayInputStream bis = new ByteArrayInputStream(data);
			ZipInputStream zip = new ZipInputStream(bis);
			byte[] bs = null;

			while (zip.getNextEntry() != null) {
				byte[] buf = new byte[250];
				int num = -1;
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				while ((num = zip.read(buf, 0, buf.length)) != -1) {
					baos.write(buf, 0, num);
				}
				bs = baos.toByteArray();
				baos.flush();
				baos.close();
			}
			zip.close();
			bis.close();

			return bs;

		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static InputStream unZipStream(InputStream is) {
		if (TypeChecker.isNull(is)) {
			return is;
		}

		try {
			return new ByteArrayInputStream(FileCopyUtils.copyToByteArray(is));
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

}
