package com.rapid.j2ee.framework.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.collections.SortHashMap;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.support.Callable;

public class StringUtils {

	private StringUtils() {

	}

	public static String encodeChineseByPinYin(String words) {
		return ChinesePinYinProperties.getInsance().getPinYinByChinese(words);
	}

	public static String encodeChineseByUpperCasePinYin(String words) {
		return encodeChineseByPinYin(words).toUpperCase();
	}

	/**
	 * 替换\n\t\r
	 * 
	 * @param source
	 * @param replacer
	 * @return
	 */
	public static String replaceEnterSepcialCharacters(String source,
			String replacer) {

		if (TypeChecker.isEmpty(source)) {
			return "";
		}

		Pattern p = Pattern.compile("\t|\r|\n");

		Matcher m = p.matcher(source);

		source = m.replaceAll(replacer);

		m = p.matcher(source);

		source = m.replaceAll("");

		return StringUtils.replace(StringUtils.replace(source, replacer
				+ replacer, replacer), replacer + replacer, replacer);

	}

	public static String replaceStringIgnoreCase(String source, String target,
			String replace) {
		if (source == null) {
			return null;
		}
		String temp = source.toLowerCase();
		String oldTemp = target.toLowerCase();
		int i = 0;
		if ((i = temp.indexOf(oldTemp, i)) >= 0) {
			char line2[] = source.toCharArray();
			char newString2[] = replace.toCharArray();
			int oLength = target.length();

			StringBuffer buf = new StringBuffer(line2.length);
			buf.append(line2, 0, i).append(newString2);
			i += oLength;
			int j;
			for (j = i; (i = temp.indexOf(oldTemp, i)) > 0; j = i) {
				buf.append(line2, j, i - j).append(newString2);
				i += oLength;
			}

			buf.append(line2, j, line2.length - j);
			return buf.toString();
		}

		return source;

	}

	public static String encodeForJavaScript(String source) {
		if (TypeChecker.isEmpty(source)) {
			return source;
		}

		source = source.trim();

		StringBuffer buffer = new StringBuffer(source.length() + 5);

		for (int i = 0; i < source.length(); i++) {
			char ch = source.charAt(i);
			switch (ch) {
			case 92: // '\\'
				buffer.append("\\\\");
				break;
			case 39: // '\''
				buffer.append("\\'");
				break;
			case 34: // '"'
				buffer.append("&quot;");
				break;
			case 13: // '\r'
				if (i < source.length() - 1 && source.charAt(i + 1) != '\n') {
					buffer.append("\\r");
				}
				break;
			case 10: // '\n'
				buffer.append("\\n");
				break;
			default:
				buffer.append(ch);
				break;
			}
		}
		return buffer.toString();
	}

	public static String htmlText(String html) {

		if (TypeChecker.isEmpty(html)) {
			return html;
		}

		return StringUtils.replaceAll(html, Html_Encode_Text_Decode_Map);

	}

	private static final Map<String, String> Html_Encode_Text_Decode_Map = new HashMap<String, String>();

	static {
		Html_Encode_Text_Decode_Map.put("&lt;", "<");
		Html_Encode_Text_Decode_Map.put("&gt;", ">");
		Html_Encode_Text_Decode_Map.put("&amp;", "&");
		Html_Encode_Text_Decode_Map.put("&nbsp;", " ");
		Html_Encode_Text_Decode_Map.put("&NBSP;", " ");
	}

	public static String printArrays(Object arrays) {

		if (TypeChecker.isNull(arrays)) {
			return "";
		}

		StringBuffer sb = new StringBuffer(50 * Array.getLength(arrays));

		for (int i = 0, j = Array.getLength(arrays); i < j; i++) {
			sb.append("[" + i + "]=[" + Array.get(arrays, i) + "]  \r\n");
		}

		return sb.toString();

	}

	public static String printCollections(Collection collection) {

		if (TypeChecker.isNull(collection)) {
			return "";
		}

		StringBuffer sb = new StringBuffer(50 * collection.size());

		for (Object item : collection) {
			sb.append("\r\n");
			sb.append(ObjectAnalyzer.toString(item));
			sb.append("\r\n");
		}

		return sb.toString();

	}

	public static String upperStartChar(String value) {

		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		if (value.length() == 1) {
			return value.toUpperCase();
		}

		return value.substring(0, 1).toUpperCase()
				+ value.substring(1, value.length());
	}

	public static String lowerStartChar(String value) {

		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		if (value.length() == 1) {
			return value.toLowerCase();
		}

		return value.substring(0, 1).toLowerCase()
				+ value.substring(1, value.length());
	}

	/**
	 * Splits this string around matches of the given closure regular
	 * expression. The string
	 * "https://websurveyor.netpaction=resume&amp;index=0&amp;
	 * ID=*{userId}&amp;wsb42=*{userId}&amp;wsb41={getCurrentDate(yyyy-MM-dd
	 * HH:mm:ss.SSS)}", for example, yields the following results with these
	 * expressions: regular expression: '{' -- start flag and '}' -- end flag
	 * return [userid, getDate(YYYY-MM-DD)]
	 * 
	 * @param starFlag -
	 *            the start regular expression
	 * @param endFlag -
	 *            the end regular expression
	 * @return the array of strings computed by splitting this string around
	 *         matches of the given regular expression
	 */
	public static String[] splitClosure(String value, String starFlag,
			String endFlag) {

		if (TypeChecker.isEmpty(value)) {
			return null;
		}

		int start = value.indexOf(starFlag);

		if (start < 0) {
			return new String[] { value };
		}
		int end = value.indexOf(endFlag, start + starFlag.length());
		if (end < 0) {
			return new String[] { value };
		}

		List rs = new ArrayList();

		String temp = "";

		while (start >= 0 && end >= 0) {

			temp = value.substring(start + starFlag.length(), end);

			rs.add(StringUtils.trimToEmpty(temp));

			value = value.substring(end + endFlag.length());

			start = value.indexOf(starFlag);

			end = value.indexOf(endFlag, start + starFlag.length());
		}

		return (String[]) rs.toArray(new String[rs.size()]);

	}

	public static String[] splitRestrictClosure(String value, String starFlag,
			String endFlag) {
		if (TypeChecker.isEmpty(value)) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}

		int start = value.indexOf(starFlag);

		if (start < 0) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}
		int end = value.indexOf(endFlag, start + starFlag.length());
		if (end < 0) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}

		List rs = new ArrayList();

		String temp = "";

		while (start >= 0 && end >= 0) {

			temp = value.substring(start + starFlag.length(), end);

			rs.add(StringUtils.trimToEmpty(temp));

			value = value.substring(end + endFlag.length());

			start = value.indexOf(starFlag);

			end = value.indexOf(endFlag, start + starFlag.length());
		}

		return (String[]) rs.toArray(new String[rs.size()]);
	}

	public static boolean isLegalContext(String source, String legalContext) {

		if (TypeChecker.isEmpty(source) || TypeChecker.isEmpty(legalContext)) {
			return true;
		}

		for (char c : source.toCharArray()) {
			if (!legalContext.contains(String.valueOf(c))) {
				return false;
			}
		}

		return true;
	}

	public static boolean contains(String source, String target,
			String separator) {
		return org.apache.commons.lang.StringUtils.contains(separator + source
				+ separator, separator + target + separator);
	}

	public static boolean contains(String source, String target) {
		return org.apache.commons.lang.StringUtils.contains(source, target);
	}

	public static boolean containsIgnoreCase(String source, String target,
			String separator) {
		return org.apache.commons.lang.StringUtils.containsIgnoreCase(separator
				+ source + separator, separator + target + separator);
	}

	public static boolean startsWithIgnoreCase(String source, String target) {
		if (source == target) {
			return true;
		}

		source = StringUtils.trimToEmpty(source).toLowerCase();

		target = StringUtils.trimToEmpty(target).toLowerCase();

		return source.startsWith(target);

	}

	public static boolean equalsIgnoreCase(String source, String target) {

		if (target == source) {
			return true;
		}

		if (target == null && source == null) {
			return true;
		}

		return org.apache.commons.lang.StringUtils.equalsIgnoreCase(source,
				target);
	}

	public static boolean equals(String source, String target) {

		if (target == source) {
			return true;
		}

		if (target == null && source == null) {
			return true;
		}

		return org.apache.commons.lang.StringUtils.equals(source, target);
	}

	public static String replaceAll(String source, String key, String value) {
		if (TypeChecker.isEmpty(key)) {
			return source;
		}
		return org.apache.commons.lang.StringUtils.replace(source, key, value);
	}

	public static String replaceAll(String source,
			Map<String, String> replacedItems) {
		return replaceAll(source, replacedItems, "", "");
	}

	public static String replaceAll(String source,
			Map<String, String> replacedItems, String startSymbol,
			String endSymbol) {

		if (TypeChecker.isEmpty(source) || TypeChecker.isEmpty(replacedItems)) {
			return source;
		}

		startSymbol = StringUtils.trimToEmpty(startSymbol);
		endSymbol = StringUtils.trimToEmpty(endSymbol);

		for (Iterator<String> it = replacedItems.keySet().iterator(); it
				.hasNext();) {
			String key = it.next();
			source = org.apache.commons.lang.StringUtils.replace(source,
					startSymbol + key + endSymbol, replacedItems.get(key));
		}

		return source;
	}

	public static String replaceAll(String source, Properties replacedItems,
			String startSymbol, String endSymbol) {

		if (TypeChecker.isEmpty(source) || TypeChecker.isEmpty(replacedItems)) {
			return source;
		}

		startSymbol = StringUtils.trimToEmpty(startSymbol);
		endSymbol = StringUtils.trimToEmpty(endSymbol);

		for (Iterator it = replacedItems.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			source = org.apache.commons.lang.StringUtils.replace(source,
					startSymbol + key + endSymbol, (String) replacedItems
							.get(key));
		}

		return source;

	}

	public static String trimObjectToEmpty(Object obj, String def) {

		if (TypeChecker.isEmptyObject(obj)) {
			return def;
		}

		return trimToEmpty(String.valueOf(obj));
	}

	public static String trimObjectToEmpty(Object obj) {

		return trimObjectToEmpty(obj, "");
	}

	public static String trimToEmpty(String value) {
		return trimToEmpty(value, "");

	}

	public static String trimToNull(String value, String def) {

		if (TypeChecker.isNull(value) || "null".equalsIgnoreCase(value)) {
			return def;
		}

		return org.apache.commons.lang.StringUtils.trimToEmpty(value);
	}

	public static String trimToEmpty(String value, String def) {

		if (TypeChecker.isEmpty(value) || "null".equalsIgnoreCase(value)) {

			return def;
		}

		return org.apache.commons.lang.StringUtils.trimToEmpty(value);
	}

	public static String trimToArrayEmpty(String value, String... def) {

		if (TypeChecker.isEmpty(value) || "null".equalsIgnoreCase(value)) {

			return StringUtils.getFirstItemVoidEmptyInArrays(def);
		}

		return org.apache.commons.lang.StringUtils.trimToEmpty(value);
	}

	public static boolean contains(Object bean, String[] fieldNames,
			String findVal, boolean ignoreCase) {

		if (TypeChecker.isEmpty(fieldNames) || TypeChecker.isNull(bean)
				|| TypeChecker.isEmpty(findVal)) {
			return false;
		}
		StringBuffer sb = new StringBuffer(50);

		for (String fieldName : fieldNames) {
			sb.append(BeanUtils.getProperty(bean, fieldName) + "``");
		}

		if (ignoreCase == true) {
			return sb.toString().toLowerCase().contains(findVal.toLowerCase());
		}

		return sb.toString().contains(findVal);

	}

	public static boolean contains(Object bean, String[] fieldNames,
			String findVal) {
		return contains(bean, fieldNames, findVal, false);

	}

	public static boolean containIngores(Object bean, String[] fieldNames,
			String findVal) {
		return contains(bean, fieldNames, findVal, true);

	}

	public static String lowerCase(String value) {
		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		return org.apache.commons.lang.StringUtils.lowerCase(value);
	}

	public static boolean matchIgnore(String target, String patter) {
		return match(org.apache.commons.lang.StringUtils.trimToEmpty(target)
				.toLowerCase(), org.apache.commons.lang.StringUtils
				.trimToEmpty(patter).toLowerCase());
	}

	public static SortHashMap splitSortHashMapByGroupKey(String taget,
			String groupReference, String keyReference) {
		return splitSortHashMapByGroupKey(taget, groupReference, keyReference,
				Callable.NONE);
	}

	public static SortHashMap splitSortHashMapByUpperCaseGroupKey(String taget,
			String groupReference, String keyReference) {
		return splitSortHashMapByGroupKey(taget, groupReference, keyReference,
				Callable.UPPERCASE);
	}

	public static SortHashMap splitSortHashMapByGroupKey(String taget,
			String groupReference, String keyReference,
			Callable<String> callable) {

		if (TypeChecker.isEmpty(taget)) {
			return ObjectUtils.EMPTY_SORTHASHMAP;
		}

		String[] groups = StringUtils.splitBySeparator(taget, groupReference);

		SortHashMap maps = new SortHashMap(groups.length);

		for (int i = 0; i < groups.length; i++) {

			if (TypeChecker.isEmpty(groups[i])) {
				continue;
			}

			maps.put(callable.call(org.apache.commons.lang.StringUtils
					.substringBefore(groups[i], keyReference)),
					org.apache.commons.lang.StringUtils.substringAfter(
							groups[i], keyReference));
		}

		return maps;
	}

	public static String getMapGroupItemBunch(Map map,
			String keyValueSeparator, String groupItemSeparator) {

		Assert.notNull(keyValueSeparator);
		Assert.notNull(groupItemSeparator);

		if (TypeChecker.isEmpty(map)) {
			return "";
		}

		StringBuffer mapGroupItemBunch = new StringBuffer(map.size() * 200);

		for (Iterator it = map.keySet().iterator(); it.hasNext();) {
			Object key = it.next();
			mapGroupItemBunch.append(key + keyValueSeparator + map.get(key));

			mapGroupItemBunch.append(groupItemSeparator);

		}

		return mapGroupItemBunch.substring(0, mapGroupItemBunch.length()
				- groupItemSeparator.length());
	}

	public static boolean match(String target, String patter) {

		if (TypeChecker.isEmpty(target)) {
			return false;
		}

		if (TypeChecker.isEmpty(patter)) {
			return false;
		}

		String s = patter;
		s = s.replace('.', '#');
		s = s.replaceAll("#", "\\\\.");
		s = s.replace('*', '#');
		s = s.replaceAll("#", ".*");
		s = s.replace('?', '#');
		s = s.replaceAll("#", ".?");
		s = "^" + s + "$";

		Pattern p = Pattern.compile(s);

		return p.matcher(target).matches();

	}

	public static String[] splitBySeparators(String source,
			String... separators) {

		if (TypeChecker.isNull(source)) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}

		Assert.noNullElements(separators, "Please provide separators!");

		String useDefSeparator = separators[0];

		for (String sep : separators) {
			if (useDefSeparator.equalsIgnoreCase(sep)) {
				continue;
			}
			source = StringUtils.replace(source, sep, useDefSeparator);

		}

		return splitBySeparator(source, useDefSeparator);
	}

	public static String[] splitBySeparator(String source, String separator) {

		return splitBySeparator(source, separator, true);

	}

	public static String[] splitBySeparator(String source, String separator,
			boolean blankIncluded) {
		if (source == null) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}
		if (separator == null || separator.length() == 0) {
			return (new String[] { source });
		}

		int startIndex = 0;

		int endIndex = source.indexOf(separator);

		List<String> items = new ArrayList<String>();

		for (; endIndex >= startIndex; endIndex = source.indexOf(separator,
				startIndex)) {

			String value = source.substring(startIndex, endIndex);

			if (!TypeChecker.isEmpty(value) || blankIncluded) {
				items.add(StringUtils.trimToEmpty(value));
			}

			startIndex = endIndex + separator.length();
		}

		String value = source.substring(startIndex);

		if (!TypeChecker.isEmpty(value) || blankIncluded) {
			items.add(StringUtils.trimToEmpty(value));
		}

		return items.toArray(new String[items.size()]);
	}

	public interface UtilityStringBunchRowable {

		public String convert(String value);

		public boolean accept(String value);
	}

	public static String getStringBunch(String[] arrays, String separator,
			int itemLength, UtilityStringBunchRowable rowable) {

		if (TypeChecker.isEmpty(arrays)) {
			return "";
		}

		StringBuffer sb = new StringBuffer(arrays.length * 10 + 10);

		String array = null;

		for (int i = 0; i < arrays.length; i++) {
			array = trimToEmpty(arrays[i]);

			if (!TypeChecker.isNull(rowable)) {

				if (!rowable.accept(array)) {
					continue;
				}

				array = rowable.convert(array);
			}

			sb.append(appendBehindCharToLength(array, " ", itemLength));

			sb.append(separator);
		}
		String tmp = sb.toString();

		if (!TypeChecker.isEmpty(tmp) && !TypeChecker.isEmpty(separator)) {
			tmp = tmp.substring(0, tmp.lastIndexOf(separator));
		}
		return tmp;

	}

	public static String getStringBunch(String[] arrays, String separator,
			int itemLength) {

		return getStringBunch(arrays, separator, itemLength, null);
	}

	public static String getStringBunch(String[] arrays, String separator) {
		return getStringBunch(arrays, separator, -1);
	}

	public static String getStringBunchUsingUnderlineAsSeparator(
			String... items) {
		return getStringBunch(items, "_");
	}

	public static String appendBeforeCharToLength(String src, String chars,
			int length) {

		if (length <= 0) {
			return src;
		}
		if (TypeChecker.isEmpty(src)) {

			return repeatChars(chars, length);
		}

		while (src.length() < length) {
			src = chars + src;
		}

		return src;
	}

	public static String appendBehindCharToLength(String src, String chars,
			int length) {
		if (length <= 0) {
			return src;
		}
		if (TypeChecker.isEmpty(src)) {

			return repeatChars(chars, length);
		}

		while (src.length() < length) {
			src += chars;
		}

		return src;
	}

	public static String repeatChars(String chars, int length) {
		if (length < 0) {
			return chars;
		}

		StringBuffer temp = new StringBuffer(chars.length() * length);

		for (int i = 0; i < length; i++) {
			temp.append(chars);
		}
		return temp.toString();
	}

	public static String repeatChars(String chars, int counts, String separator) {
		if (counts < 0) {
			return chars;
		}

		StringBuffer temp = new StringBuffer(chars.length() * counts
				+ separator.length() * counts);

		for (int i = 0; i < counts; i++) {
			temp.append(chars);
			if (i != counts - 1) {
				temp.append(separator);
			}
		}
		return temp.toString();
	}

	public static String getStringBunch(Collection<String> coll,
			String separator) {
		return getStringBunch(coll, separator, -1);
	}

	public static String getStringBunch(Collection<String> coll,
			String separator, int itemLength) {
		if (TypeChecker.isEmpty(coll)) {
			return repeatChars(" ", itemLength);
		}
		return getStringBunch((String[]) coll.toArray(new String[coll.size()]),
				separator, itemLength);
	}

	public static String getStringBunch(Collection<String> coll,
			String separator, int itemLength, UtilityStringBunchRowable rowable) {
		if (TypeChecker.isEmpty(coll)) {
			return repeatChars(" ", itemLength);
		}
		return getStringBunch((String[]) coll.toArray(new Object[coll.size()]),
				separator, itemLength, rowable);
	}

	public static int getOccuredCounts(String source, String target) {
		if (TypeChecker.isNull(target) || TypeChecker.isNull(source)) {
			return 0;
		}

		int index = 0;
		int occuredCounts = 0;

		while ((index = source.indexOf(target)) != -1) {
			occuredCounts++;
			source = org.apache.commons.lang.StringUtils.substringAfter(source,
					target);
		}

		return occuredCounts;

	}

	public static String getStringBunchByObjectFieldNames(Object value,
			String separator, Field... fields) {

		String[] fieldName = new String[fields.length];

		for (int i = 0; i < fields.length; i++) {
			fieldName[i] = fields[i].getName();
		}

		return getStringBunchByObjectFieldNames(value, separator, fieldName);
	}

	public static String getStringBunchByObjectFieldNames(Object value,
			String separator, String... fieldNames) {

		if (TypeChecker.isNull(value) || TypeChecker.isNull(fieldNames)) {
			return "";
		}

		StringBuffer sb = new StringBuffer(fieldNames.length * 50);

		for (String fieldName : fieldNames) {
			sb.append(StringUtils.trimToEmpty(BeanUtils.getProperty(value,
					fieldName)));
			sb.append(separator);
		}

		return sb.toString().substring(0, sb.length() - separator.length());

	}

	public static String getStringBunchByFieldName(Collection coll,
			String separator, String fieldName) {

		Collection values = ObjectUtils.getFieldValuesByName(coll, fieldName);

		return getStringBunch((String[]) values.toArray(new String[values
				.size()]), separator);
	}

	public static String[] splitByLength(String value, int len) {

		if (TypeChecker.isEmpty(value) || value.length() <= len) {
			return new String[] { org.apache.commons.lang.StringUtils
					.trimToEmpty(value) };
		}

		List arrays = new ArrayList(5);

		while (value.length() > len) {
			arrays.add(value.substring(0, len));
			value = value.substring(len);
		}

		if (!TypeChecker.isEmpty(value)) {
			arrays.add(value);
		}

		return (String[]) arrays.toArray(new String[arrays.size()]);

	}

	public static String substringAfter(String str, String separator) {
		if (TypeChecker.isNull(str) || TypeChecker.isNull(separator)) {
			return "";
		}

		return org.apache.commons.lang.StringUtils.substringAfter(str,
				separator);
	}

	public static String substringAfterLast(String str, String separator) {
		if (TypeChecker.isNull(str) || TypeChecker.isNull(separator)) {
			return "";
		}

		return org.apache.commons.lang.StringUtils.substringAfterLast(str,
				separator);
	}

	public static String substringBefore(String str, String separator) {

		if (TypeChecker.isNull(str) || TypeChecker.isNull(separator)) {
			return str;
		}

		return org.apache.commons.lang.StringUtils.substringBefore(str,
				separator);

	}

	public static String substringBeforeLast(String str, String separator) {

		if (TypeChecker.isNull(str) || TypeChecker.isNull(separator)) {
			return str;
		}

		return org.apache.commons.lang.StringUtils.substringBeforeLast(str,
				separator);

	}

	public static int indexOfIgnoreCase(String str, String target) {
		if (TypeChecker.isNull(str) || TypeChecker.isNull(target)) {

			return -1;
		}

		return org.apache.commons.lang.StringUtils.indexOfIgnoreCase(str,
				target);
	}

	public static String replaceOnce(String text, String repl, String with) {
		if (TypeChecker.isEmpty(text) || TypeChecker.isNull(repl)
				|| TypeChecker.isNull(with)) {
			return text;
		}

		return org.apache.commons.lang.StringUtils
				.replaceOnce(text, repl, with);
	}

	public static String replace(String text, String repl, String with) {

		if (TypeChecker.isEmpty(text) || TypeChecker.isNull(repl)
				|| TypeChecker.isNull(with)) {
			return text;
		}

		return org.apache.commons.lang.StringUtils.replace(text, repl, with);

	}

	public static String[] split(String text, String flag) {

		if (TypeChecker.isEmpty(text) || TypeChecker.isNull(flag)) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}

		return org.apache.commons.lang.StringUtils.split(text, flag);
	}

	public static String remove(String text, String... flags) {
		if (TypeChecker.isEmpty(text) || TypeChecker.isNull(flags)) {
			return text;
		}

		for (String flag : flags) {
			text = org.apache.commons.lang.StringUtils.remove(text, flag);

		}

		return text;
	}

	public static String getOverleapContext(String context, int validLength) {

		if (TypeChecker.isEmpty(context)) {
			return "";
		}

		context = StringUtils.trimToEmpty(context);

		if (context.length() <= validLength) {
			return context;
		}

		return context.substring(0, validLength) + "...";
	}

	public static int countsByTarget(String value, String target) {
		if (TypeChecker.isEmpty(value) || TypeChecker.isEmpty(target)) {
			return 0;
		}

		int targetIndex = value.indexOf(target);

		int repeat = 0;

		while (targetIndex >= 0) {
			repeat++;

			targetIndex = value.indexOf(target, targetIndex + target.length());
		}

		return repeat;

	}

	public static int countsIngoreCaseByTarget(String value, String target) {
		return countsByTarget(StringUtils.trimToEmpty(value).toLowerCase(),
				StringUtils.trimToEmpty(target).toLowerCase());
	}

	public static String getFirstItemVoidEmptyInArrays(String... items) {

		if (TypeChecker.isEmpty(items)) {
			return "";
		}

		for (String item : items) {
			if (!TypeChecker.isEmpty(item)) {
				return StringUtils.trimToEmpty(item);
			}
		}

		return "";
	}

	public static String convertFieldNameToXmlTagName(String fieldName) {
		return convertFieldNameToXmlTagName(fieldName, false);
	}

	public static String convertClassToMybatisResultMap(Class resultMapClass) {

		StringBuffers sb = new StringBuffers(500);

		sb.appendln("<resultMap class=\"" + resultMapClass.getName()
				+ "\" id=\"" + resultMapClass.getSimpleName() + "\">");
		for (Field f : ClassUtils.getAllFieldsAsClass(resultMapClass)) {
			sb.appendln("<result property=\""
					+ f.getName()
					+ "\" column=\""
					+ StringUtils.replace(
							StringUtils.convertFieldNameToXmlTagName(f
									.getName()), "-", "_").toUpperCase()
					+ "\" />");
		}
		sb.appendln("</resultMap >");

		return sb.toString();
	}

	public static String convertFieldNameToXmlTagName(String fieldName,
			boolean humps) {

		if (TypeChecker.isEmpty(fieldName)) {
			return humps ? "emptyTag" : "empty-tag";
		}

		fieldName = StringUtils.trimToEmpty(fieldName);

		if (humps) {
			return fieldName.substring(0, 1).toLowerCase()
					+ fieldName.substring(1);
		}

		StringBuffer sb = new StringBuffer(fieldName.length() + 5);

		for (int i = 0, j = fieldName.length(); i < j; i++) {
			char c = fieldName.charAt(i);

			if (isUpperCaseLetter(c)) {

				if (i != 0) {
					sb.append("-");
				}

			}

			sb.append(String.valueOf(c).toLowerCase());

		}

		return sb.toString();
	}

	public static boolean isUpperCaseLetter(char c) {
		int cInt = (int) c;

		return c >= A_ASCII && c <= Z_ASCII;
	}

	public static int getStringLengthWith2DigitAtOver255Ascii(String src) {
		return getStringLengthWithSpecialDigitAtOver255Ascii(src, 2);
	}

	public static int getStringLengthWith3DigitAtOver255Ascii(String src) {
		return getStringLengthWithSpecialDigitAtOver255Ascii(src, 3);
	}

	public static int getStringLengthWithSpecialDigitAtOver255Ascii(String src,
			double over255Length) {
		if (TypeChecker.isEmpty(src)) {
			return 0;
		}

		double totalLength = 0;

		for (int i = 0; i < src.length(); i++) {
			if ((int) src.charAt(i) < 255) {
				totalLength = totalLength + 1;
				continue;
			}

			totalLength = totalLength + over255Length;
		}
		return (int) totalLength;
	}

	public static String getStringContextWithinLength(String src,
			double over255CharSize, int maxLength, String endValue) {

		if (TypeChecker.isEmpty(src)) {
			return src;
		}

		StringBuffer context = new StringBuffer(src.length());

		double contextLength = getStringLengthWithSpecialDigitAtOver255Ascii(
				endValue, over255CharSize);

		boolean overMaxLength = false;
		for (int i = 0, j = src.length(); i < j; i++) {

			char c = src.charAt(i);

			if (((int) c) < 255) {
				contextLength = contextLength + 1;
			} else {
				contextLength = contextLength + over255CharSize;
			}

			if (contextLength > maxLength) {
				overMaxLength = true;
				break;
			}
			context.append(c);

		}

		return overMaxLength ? context.toString() + endValue : context
				.toString();
	}

	public static List<String> splitBySwitchChineseAndEnglishLetterChar(
			String words) {

		if (TypeChecker.isEmpty(words)) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<String> arrays = new ArrayList<String>();

		boolean charType = isChineseChar(words.charAt(0));
		String word = "";
		for (int i = 0, j = words.length(); i < j; i++) {

			if (words.charAt(i) != ' ' && !isChineseChar(words.charAt(i))
					&& !isEnglishLetterChar(words.charAt(i))) {
				continue;
			}

			if (charType == isChineseChar(words.charAt(i))) {
				word += words.charAt(i);
				continue;
			}

			arrays.add(word.trim());
			charType = isChineseChar(words.charAt(i));
			word = String.valueOf(words.charAt(i));

		}

		if (!TypeChecker.isEmpty(word)) {
			arrays.add(word);
		}

		return arrays;
	}

	public static List<String> getSingleWordArrays(String words) {

		List<String> tempWords = splitBySwitchChineseAndEnglishLetterChar(words);

		List<String> singleWordArrays = new ArrayList<String>();

		for (String tempWord : tempWords) {

			if (TypeChecker.isEmpty(tempWord)) {
				continue;
			}

			if (isChineseChar(tempWord.charAt(0))) {
				singleWordArrays.addAll(new ArrayList<String>(Arrays
						.asList(toStringArrays(tempWord.toCharArray()))));
				continue;

			}

			singleWordArrays
					.addAll(new ArrayList<String>(Arrays.asList(StringUtils
							.splitBySeparator(tempWord, " ", true))));

		}

		return singleWordArrays;
	}

	public static String[] toStringArrays(char[] chars) {

		if (TypeChecker.isNull(chars)) {
			return ObjectUtils.EMPTY_STRING_ARRAYS;
		}

		String[] charStrings = new String[chars.length];

		for (int i = 0; i < chars.length; i++) {
			charStrings[i] = String.valueOf(chars[i]);
		}

		return charStrings;

	}

	public static boolean isChineseChar(char c) {
		return ((int) c) > 255;
	}

	public static boolean isEnglishLetterChar(char c) {
		int cInt = ((int) c);
		return (cInt >= (int) 'A' && cInt <= (int) 'Z')
				|| (cInt >= (int) 'a' && cInt <= (int) 'z');
	}

	public static String getMaxValue(String... strings) {
		if (TypeChecker.isEmpty(strings)) {
			return "";
		}

		String target = null;

		for (String value : strings) {

			if (TypeChecker.isEmpty(value)) {
				continue;
			}

			if (target == null) {
				target = value;
				continue;
			}

			if (value.compareTo(target) > 0) {
				target = value;
			}
		}

		return target;
	}

	public static String getMinValue(String... strings) {
		if (TypeChecker.isEmpty(strings)) {
			return "";
		}

		String target = null;

		for (String value : strings) {
			if (TypeChecker.isEmpty(value)) {
				continue;
			}
			if (target == null) {
				target = value;
				continue;
			}

			if (value.compareTo(target) < 0) {
				target = value;
			}
		}

		return target;
	}

	public static InputStream getInputStream(String content, String charset) {

		if (TypeChecker.isEmpty(content)) {
			return new ByteArrayInputStream(new byte[0]);
		}

		try {
			byte[] bytes = content.getBytes(charset);

			return new ByteArrayInputStream(bytes);

		} catch (UnsupportedEncodingException e) {
			return new ByteArrayInputStream(new byte[0]);
		}
	}

	public static String copy(InputStream is, String charset) {
		InputStreamReader isr = null;

		try {
			isr = new InputStreamReader(is, charset);
			return FileCopyUtils.copyToString(isr);
		} catch (Exception e) {
			return "";
		} finally {
			try {
				isr.close();
			} catch (Exception e) {

			}
		}

	}

	public static String copy(Reader reader) {
		try {
			return FileCopyUtils.copyToString(reader);
		} catch (Exception e) {
			return "";
		} finally {
			try {
				reader.close();
			} catch (Exception e) {

			}
		}
	}

	public static String reverse(String value) {

		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		return org.apache.commons.lang.StringUtils.reverse(value);
	}

	public static void main(String[] args) {

		System.out.println(StringUtils.replaceStringIgnoreCase(
				"HaohaiJiaohaohaijiao", "HAI", "hAi"));

	}

	public static String trimRowLineTexts(String text) {

		if (TypeChecker.isEmpty(text)) {
			return text;
		}

		StringReader sr = new StringReader(text);

		BufferedReader br = new BufferedReader(sr);

		String line = "";

		try {

			StringBuffer sb = new StringBuffer(text.length());

			while ((line = br.readLine()) != null) {
				sb.append(StringUtils.trimToEmpty(line) + "\n");
			}

			br.close();

			return StringUtils.replace(StringUtils.trimToEmpty(sb.toString()),
					"<SPACE>", " ");

		} catch (Exception e) {
			return text;
		}
	}

	public static final String DEFAULT_SHARED_SEPARATOR_SYMBOL = "; ";

	private static final int A_ASCII = (int) 'A';

	private static final int Z_ASCII = (int) 'Z';
}
