package com.rapid.j2ee.framework.core.utils;

import java.beans.BeanInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;

public class SystemPropertiesConfigurer implements InitializingBean {

	public SystemPropertiesConfigurer() {

	}

	public void setCharsetType(String charsetType) {
		this.charsetType = charsetType;
	}

	public void setPropertiesLocations(String[] propertiesLocations) {
		this.propertiesLocations = propertiesLocations;
	}

	private String charsetType = CharsetType.UTF_8;

	private String[] propertiesLocations = ObjectUtils.EMPTY_STRING_ARRAYS;

	public void afterPropertiesSet() throws Exception {

		System.out
				.println("afterPropertiesSet() ======================== called.......");

		Resource[] resources = ResourceUtils.getResources(propertiesLocations);

		for (Resource resource : resources) {

			System.out.println("Properties......"
					+ PropertiesUtils.newProperties(resource.getInputStream(),
							Charsets.getCharsetInstance(this.charsetType)));

			System.getProperties().putAll(
					PropertiesUtils.newProperties(resource.getInputStream(),
							Charsets.getCharsetInstance(this.charsetType)));
		}

	}

}
