package com.rapid.j2ee.framework.core.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

import com.rapid.j2ee.framework.core.pagination.PageOutput;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils.DateTimeBean;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public final class TypeChecker {

	public static boolean isJsonContextType(String type) {
		type = StringUtils.trimToEmpty(type);
		return "application/json".equalsIgnoreCase(type)
				|| "text/json".equalsIgnoreCase(type);
	}

	public static interface TypeMoreChecker {
		public boolean validate(Object... parameters);
	}

	public static boolean isDateTime(String dateTime, String format) {
		return isDateTime(dateTime, format, null);
	}

	public static boolean isDateTime(String dateTime, String format,
			TypeMoreChecker typeMoreChecker) {

		if (TypeChecker.isEmpty(dateTime)) {
			return true;
		}

		DateTimeBean dateTimeBean = DateTimeUtils.parseDateTimeByFormat(
				dateTime, format);

		if (TypeChecker.isNull(dateTimeBean)) {
			return false;
		}

		dateTime = dateTimeBean.getDateTimeTextByFormat(format);

		Date dateTimeObject = DateTimeUtils.convertWebToDate(dateTime,
				DateTimeFormat.getDateTimeFormat(format));

		if (TypeChecker.isNull(dateTimeObject)) {
			return false;
		}

		if (!StringUtils.equalsIgnoreCase(dateTime, DateTimeUtils
				.convertDateToWeb(dateTimeObject, DateTimeFormat
						.getDateTimeFormat(format)))) {
			return false;
		}

		if (TypeChecker.isNull(typeMoreChecker)) {
			return true;
		}

		return typeMoreChecker.validate(dateTime, format, dateTimeBean);
	}

	public static boolean isBlueNumber(Object obj) {

		if (isNull(obj)) {
			return false;
		}

		return StringUtils.isLegalContext(String.valueOf(obj), "0123456789.+-");

	}

	public static boolean isNumber(Object obj) {

		if (obj instanceof Number) {
			return true;
		}

		if (!isBlueNumber(obj)) {
			return false;
		}

		try {
			Double.parseDouble(String.valueOf(obj));

		} catch (Exception e) {

			return false;
		}

		return true;
	}

	public static boolean isInteger(Object obj) {

		if (!isBlueNumber(obj)) {
			return false;
		}

		try {
			Integer.parseInt(String.valueOf(obj));

		} catch (Exception e) {

			return false;
		}

		return true;
	}

	public static boolean isPlusInteger(Object obj) {

		if (!isBlueNumber(obj)) {
			return false;
		}

		try {
			return Integer.parseInt(String.valueOf(obj)) >= 0;

		} catch (Exception e) {

			return false;
		}

	}

	public static boolean isLong(Object obj) {
		if (isNull(obj)) {
			return false;
		}

		try {
			long l = Long.parseLong(String.valueOf(obj));

		} catch (Exception e) {

			return false;
		}

		return true;
	}

	public static boolean isEmptyObject(Object obj) {

		if (TypeChecker.isNull(obj)) {
			return true;
		}

		if (obj instanceof Object[]) {
			return Array.getLength(obj) == 0;
		}

		if (obj instanceof Collection) {
			return isEmpty((Collection) obj);
		}

		if (obj instanceof Map) {
			return isEmpty((Map) obj);
		}

		if (obj instanceof String) {
			return isEmpty((String) obj);
		}

		if (obj instanceof PageOutput) {
			return ((PageOutput) obj).isEmpty();
		}

		return false;
	}

	public static boolean isEmptySQL(String sql) {
		if (TypeChecker.isNull(sql) || TypeChecker.isEmpty(sql)) {
			return true;
		}

		for (int i = 0, j = sql.length(); i < j; i++) {
			if (sql.charAt(i) != '%') {
				return false;
			}
		}

		return true;

	}

	public static boolean isEmpty(Object[] arrays) {
		return TypeChecker.isNull(arrays) || arrays.length == 0;

	}

	public static boolean isEmptyStringArrays(String... arrays) {

		if (TypeChecker.isEmpty(arrays)) {
			return true;
		}

		for (String item : arrays) {
			if (!TypeChecker.isEmpty(item)) {
				return false;
			}
		}

		return true;

	}

	public static boolean isEmpty(StringBuffer sb) {
		return TypeChecker.isNull(sb) || sb.length() == 0;

	}

	public static boolean isEmpty(Collection collection) {

		return isNull(collection) || collection.isEmpty();

	}

	public static boolean isEmpty(Map map) {

		return isNull(map) || map.isEmpty();

	}

	public static boolean isEmpty(String str) {

		return isNull(str) || str.trim().length() == 0
				|| "null".equalsIgnoreCase(str);
	}

	public static boolean isNull(Object obj) {
		return obj == null;
	}

	public static boolean isOrNull(Object... objs) {
		if (TypeChecker.isNull(objs)) {
			return true;
		}

		for (Object obj : objs) {
			if (TypeChecker.isNull(obj)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isTrue(String value) {
		return "true".equalsIgnoreCase(value);
	}

	public static boolean isSpecialTrue(String value) {
		return "true".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value)
				|| "a".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value)
				|| "yes".equalsIgnoreCase(value);
	}

	public static boolean isSpecialFalse(String value) {
		return "false".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value)
				|| "n".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)
				|| TypeChecker.isEmpty(value);
	}

	public static boolean isFalse(String value) {
		return "false".equalsIgnoreCase(value) || TypeChecker.isEmpty(value);
	}

	private TypeChecker() {

	}

	public static void main(String[] args) {

	}
}
