package com.rapid.j2ee.framework.core.utils.lang;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class StringBuffers {

	private StringBuffer sb = null;

	private final static String NEW_LINE = "\r\n";

	public StringBuffers() {
		sb = new StringBuffer();
	}

	public StringBuffers(int size) {
		sb = new StringBuffer(size);
	}

	public StringBuffers(String str) {
		sb = new StringBuffer(str);
	}

	public StringBuffers appendTrimln(String str) {

		return appendln(StringUtils.trimToEmpty(str));
	}

	public StringBuffers appendln(String str) {
		append(str);

		append(NEW_LINE);

		return this;
	}

	public StringBuffers newAppendln(String str) {
		sb = new StringBuffer();
		this.appendln(str);
		return this;
	}

	public StringBuffers appendSpace(String str) {
		append(str + " ");
		return this;
	}

	public StringBuffers append(String str) {
		sb.append(str);
		return this;
	}

	public String toString() {
		return sb.toString();
	}

	public StringBuffers appendFirst(String str) {
		this.sb.insert(0, str);
		return this;
	}

}