package com.rapid.j2ee.framework.core.utils.support;

import com.opensymphony.xwork2.ActionContext;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public interface Callable<T> {

	public T call(T value, Object... arguments);

	public static final Callable NONE = new Callable() {

		public Object call(Object value, Object... arguments) {

			return value;
		}

	};

	public static final Callable<String> UPPERCASE = new Callable<String>() {

		public String call(String value, Object... arguments) {

			return StringUtils.trimToEmpty(value).toUpperCase();
		}

	};

	public static final Callable<String> LOWERCASE = new Callable<String>() {

		public String call(String value, Object... arguments) {

			return StringUtils.trimToEmpty(value).toLowerCase();
		}

	};

	public static final Callable<String> STACKVALUE = new Callable<String>() {

		public String call(String value, Object... arguments) {

			if (!ActionContextUtils.existsActionContext()) {
				return value;
			}

			if (TypeChecker.isEmpty(value)) {
				return value;
			}

			if (!TypeChecker.isEmpty(arguments)) {

				for (Object parm : arguments) {
					ActionContext.getContext().getValueStack().push(parm);
				}

			}

			if (value.startsWith("%{") && value.endsWith("}")) {

				value = (String) ActionContext.getContext().getValueStack()
						.findValue(StringUtils.remove(value, "%{", "}"));
			}

			if (!TypeChecker.isEmpty(arguments)) {
				for (Object parm : arguments) {
					ActionContext.getContext().getValueStack().pop();
				}
			}

			return value;
		}

	};

}
