package com.rapid.j2ee.framework.core.utils.support;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class CollectionItemNotEmptyFieldSelector implements ItemSelector,
		ItemFieldSelector {

	private String fieldName;

	public CollectionItemNotEmptyFieldSelector(String fieldName) {
		this.fieldName = fieldName;
	}

	public boolean accept(Object item, Object comparedObject) {

		return !TypeChecker.isEmptyObject(item);
	}

	public Object resolve(Object item) {

		return BeanUtils.getPropertyObject(item, fieldName);
	}

	public String getFieldName() {

		return fieldName;
	}

}