package com.rapid.j2ee.framework.core.utils.support;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class DateTimeFormat {

	public final static DateTimeFormat YYYY = new DateTimeFormat("yyyy");

	public final static DateTimeFormat YYYY_MM = new DateTimeFormat("yyyy-MM");

	public final static DateTimeFormat MMDD = new DateTimeFormat("MMdd");

	public final static DateTimeFormat YYYY_MM_DD = new DateTimeFormat(
			"yyyy-MM-dd");

	public final static DateTimeFormat YYYY_MM_DD_HH_MM = new DateTimeFormat(
			"yyyy-MM-dd HH:mm");

	public final static DateTimeFormat YYYY_MM_DD_HH_MM_SS = new DateTimeFormat(
			"yyyy-MM-dd HH:mm:ss");

	public final static DateTimeFormat YYYYMMDDHHMMSS_CHINESE = new DateTimeFormat(
			"yyyy年MM月dd日HH时mm分ss秒");

	public final static DateTimeFormat YYYYMMDDHHMM_CHINESE = new DateTimeFormat(
			"yyyy年MM月dd日HH时mm分");

	public final static DateTimeFormat YYYYMMDD_CHINESE = new DateTimeFormat(
			"yyyy年MM月dd日");

	public final static DateTimeFormat YYYY_MM_DD_HH_MM_SS_SSS = new DateTimeFormat(
			"yyyy-MM-dd HH:mm:ss.SSS");

	public final static DateTimeFormat YYYYMMDD = new DateTimeFormat("yyyyMMdd");

	public final static DateTimeFormat YYYYSLASHMMSLASHDD = new DateTimeFormat(
			"yyyy/MM/dd");

	public final static DateTimeFormat HH_MM = new DateTimeFormat("HH:mm");

	public final static DateTimeFormat HH_MM_SS = new DateTimeFormat("HH:mm:ss");

	public final static DateTimeFormat HH_MM_SS_SSS = new DateTimeFormat(
			"HH:mm:ss.SSS");

	public final static DateTimeFormat YYYYMMDDHHMMSS = new DateTimeFormat(
			"yyyyMMddHHmmss");

	private final static Map<String, DateTimeFormat> container = new HashMap<String, DateTimeFormat>();

	public static String resolveDateTimeFormat(String format) {
		Assert.hasLength(format);

		format = StringUtils.replaceAll(format, "Y", "y");
		format = StringUtils.replaceAll(format, "m", "M");
		format = StringUtils.replaceAll(format, "D", "d");
		format = StringUtils.replaceAll(format, "h", "H");

		format = StringUtils.replaceAll(format, ":MM", ":mm");

		format = StringUtils.replaceAll(format, "S", "s");

		format = StringUtils.replaceAll(format, ".sss", ".SSS");

		return format;

	}

	private String format;

	private DateTimeFormat(String format) {
		this.format = format;
	}

	public SimpleDateFormat getSimpleDateFormat() {
		return new SimpleDateFormat(this.format);
	}

	public synchronized static DateTimeFormat getDateTimeFormat(String format) {
		format = StringUtils.trimToEmpty(format);

		if (!container.containsKey(format)) {
			container.put(format, new DateTimeFormat(format));
		}

		return container.get(format);
	}

	public String getFormat() {
		return format;
	}

}
