package com.rapid.j2ee.framework.core.utils.support;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

import org.springframework.util.AntPathMatcher;

public class FileAntPatternFilter implements FileFilter {

	private String antPattern;

	private AntPathMatcher antPathMatcher;

	public FileAntPatternFilter(String antPattern) {
		this.antPattern = antPattern;
		antPathMatcher = new AntPathMatcher();
	}

	public boolean accept(File file) {

		return antPathMatcher.match(antPattern, file.getAbsolutePath())
				|| antPathMatcher.match(antPattern, file.getName());

	}

}
