package com.rapid.j2ee.framework.core.utils.support;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class ItemFieldNameSelector implements ItemSelector {

	private String[] fieldNames;

	public ItemFieldNameSelector(String... fieldNames) {
		this.fieldNames = fieldNames;
	}

	public boolean accept(Object item, Object comparedObject) {

		if (item instanceof String && comparedObject instanceof String) {
			return StringUtils.equals((String) item, (String) comparedObject);
		}

		if (item instanceof String && !(comparedObject instanceof String)) {
			return StringUtils.equals((String) item, StringUtils
					.getStringBunchByObjectFieldNames(comparedObject, "",
							fieldNames));
		}

		if (!(item instanceof String) && comparedObject instanceof String) {
			return StringUtils.equals((String) comparedObject, StringUtils
					.getStringBunchByObjectFieldNames(item, "", fieldNames));
		}

		return StringUtils.getStringBunchByObjectFieldNames(item, "~|~",
				fieldNames).equals(
				StringUtils.getStringBunchByObjectFieldNames(comparedObject,
						"~|~", fieldNames));
	}

	public Object resolve(Object item) {

		return item;
	}

}
