package com.rapid.j2ee.framework.core.utils.support;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class ItemNotEmptySelector implements ItemSelector, ItemFieldSelector {

	private String fieldName;

	public ItemNotEmptySelector(String fieldName) {
		this.fieldName = fieldName;

	}

	public boolean accept(Object item, Object comparedObject) {

		return !TypeChecker.isEmptyObject(BeanUtils.getPropertyObject(item,
				fieldName));
	}

	public Object resolve(Object item) {

		return item;
	}

	public String getFieldName() {

		return fieldName;
	}

}
