package com.rapid.j2ee.framework.core.utils.ui;

import java.io.InputStreamReader;

import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class WebViewerHtmlDecoration {

	public WebViewerHtmlDecoration() {

	}

	public String decorate(String beforeHtml) {

		try {

			synchronized (this) {

				if (TypeChecker.isEmpty(contentCached)) {

					contentCached = FileCopyUtils
							.copyToString(new InputStreamReader(
									webViewerHtmlDecorationTemplationResource
											.getInputStream(), this.charset));
				}
			}

			return StringUtils.replace(contentCached,
					this.targetHtmlContentName, beforeHtml);

		} catch (Exception e) {
			e.printStackTrace();
		}

		return beforeHtml;
	}

	public void setTargetHtmlContentName(String targetHtmlContentName) {
		this.targetHtmlContentName = targetHtmlContentName;
	}

	public void setCharset(String charset) {
		this.charset = charset;
	}

	public void setWebViewerHtmlDecorationTemplation(
			String webViewerHtmlDecorationTemplation) {

		this.webViewerHtmlDecorationTemplation = webViewerHtmlDecorationTemplation;

		webViewerHtmlDecorationTemplationResource = ResourceUtils
				.getResource(this.webViewerHtmlDecorationTemplation);
	}

	private String contentCached = null;

	private String webViewerHtmlDecorationTemplation;

	private Resource webViewerHtmlDecorationTemplationResource;

	private String charset = "utf-8";

	private String targetHtmlContentName = "{WebHtmlContent}";

}
