package com.rapid.j2ee.framework.core.utils.verificationcode;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Random;

import javax.imageio.ImageIO;

import com.rapid.j2ee.framework.core.utils.verificationcode.AbstractVerificationImageCodeGenerator;

public class VerificationImageCodePencilGenerator extends
		AbstractVerificationImageCodeGenerator {

	public void drawVerificationCodeImage(OutputStream os, String imageCode) {

		BufferedImage image = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_BGR);

		// 产生Image对象的Graphics对象,改对象可以在图像上进行各种绘制操作
		Graphics g = image.getGraphics();

		g.fillRect(0, 0, width, height);
		g.setFont(new Font("Times New Roman", Font.ROMAN_BASELINE, 18));
		g.setColor(getRandColor(110, 133));

		// 绘制干扰线
		for (int i = 0; i <= interferingLineCount; i++) {
			drowLine(g);
		}

		// 绘制随机字符个数
		int stringNum = imageCode.length();

		char[] imageCodeChars = imageCode.toCharArray();

		for (int i = 0; i < stringNum; i++) {
			drowString(g, imageCodeChars[i] + "", i);
		}

		g.dispose();

		try {
			ImageIO.write(image, "JPEG", os);// 将内存中的图片通过流动形式输出到客户端
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	 * 获得颜色
	 */
	private Color getRandColor(int fc, int bc) {
		if (fc > 255)
			fc = 255;
		if (bc > 255)
			bc = 255;
		int r = fc + random.nextInt(bc - fc - 16);
		int g = fc + random.nextInt(bc - fc - 14);
		int b = fc + random.nextInt(bc - fc - 18);
		return new Color(r, g, b);
	}

	/*
	 * 绘制字符串
	 */
	private void drowString(Graphics g, String rand, int i) {
		g.setFont(getFont());
		g.setColor(new Color(random.nextInt(101), random.nextInt(111), random
				.nextInt(121)));
		g.translate(random.nextInt(3), random.nextInt(3));

		g.drawString(rand, (i == 0 ? 5 : wordSpace * i + 5), 16);
	}

	/*
	 * 绘制干扰线
	 */
	private void drowLine(Graphics g) {
		int x = random.nextInt(width);
		int y = random.nextInt(height);
		int xl = random.nextInt(13);
		int yl = random.nextInt(15);
		g.drawLine(x, y, x + xl, y + yl);
	}

	/*
	 * 获得字体
	 */
	private Font getFont() {

		return new Font(fontName, Font.CENTER_BASELINE, 18);
	}

	public void setFontName(String fontName) {
		this.fontName = fontName;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public void setInterferingLineCount(int interferingLineCount) {
		this.interferingLineCount = interferingLineCount;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public void setWordSpace(int wordSpace) {
		this.wordSpace = wordSpace;
	}

	private String fontName = "Fixedsys";

	private int width = 56;// 图片宽

	private int height = 26;// 图片高

	private int wordSpace = 15; // 字间距

	private int interferingLineCount = 40;// 干扰线数量

	private Random random = new Random();

}
