package com.rapid.j2ee.framework.core.utils.verificationcode;

import javax.servlet.http.HttpServletResponse;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.utils.CookieUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public final class VerificationImageCodeUtils {

	public static String getVerificationImageHashcode(String verificationCode) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		String newVerificationCode = DateTimeUtils
				.getCurrentWebDate(DateTimeFormat.YYYY_MM_DD)
				+ VerificationImageCodeUtils.class.getName() + verificationCode;

		return CryptologyFactory.getSingleCryptology(CryptologyType.Md5)
				.encrypt(newVerificationCode);
	}

	public static boolean isVerificationImageCodeValid(String verificationCode,
			String verificationHashcode) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		if (TypeChecker.isEmpty(verificationCode)) {
			return false;
		}

		return StringUtils.indexOfIgnoreCase(verificationHashcode,
				getVerificationImageHashcode(verificationCode)) >= 0;

	}

	public static void addVerificationImageCodeCookie(String verificationCode,
			int cookieAgeUnitSec) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		String verificationHashcodes = CookieUtils.getCookieValue(CookieUtils
				.getCookie(VerificationImage_Cookie_Name), "");

		if (!TypeChecker.isEmpty(verificationHashcodes)) {

			String[] hashcodes = StringUtils.splitBySeparator(
					verificationHashcodes, VerificationCode_Multiple_Separator);

			verificationHashcodes = "";

			for (int i = hashcodes.length - 1; i >= Math
					.max(
							0,
							(hashcodes.length - (Last_VerificationCode_Valid_Number - 1))); i--) {
				verificationHashcodes += ((hashcodes[i]) + VerificationCode_Multiple_Separator);
			}

			CookieUtils.addCookie(VerificationImage_Cookie_Name,
					verificationHashcodes + VerificationCode_Multiple_Separator
							+ getVerificationImageHashcode(verificationCode),
					cookieAgeUnitSec);

			return;
		}

		CookieUtils.addCookie(VerificationImage_Cookie_Name,
				getVerificationImageHashcode(verificationCode),
				cookieAgeUnitSec);

	}

	public static boolean isVerificationImageCodeValidByCookie(
			String verificationCode) {

		return isVerificationImageCodeValid(verificationCode, CookieUtils
				.getCookieValue(CookieUtils
						.getCookie(VerificationImage_Cookie_Name), ""));
	}

	private static final String VerificationImage_Cookie_Name = "sso-johnhao-cookie3";

	private static final int Last_VerificationCode_Valid_Number = 5;

	public static final String VerificationCode_Multiple_Separator = "|";

	private VerificationImageCodeUtils() {

	}
}
