package com.rapid.j2ee.framework.core.utils.verificationcode;

import java.util.Random;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.utils.CookieUtils;
import com.rapid.j2ee.framework.core.utils.RandomUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public final class VerificationSMSCodeUtils {

	public static String nextVerificationCode(int length) {

		return RandomUtils.nextRandomNumber(length);

	}

	public static String nextVerificationCode() {

		return nextVerificationCode(Verfication_Length);

	}

	public static String getVerificationHashcode(String mobileNo,
			String verificationCode) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		return CryptologyFactory.getSingleCryptology(CryptologyType.Md5)
				.encrypt(
						mobileNo + verificationCode
								+ VerificationSMSCodeUtils.class);
	}

	public static boolean isVerificationHashcodeValid(String mobileNo,
			String verificationCode, String hashcode) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		return StringUtils.indexOfIgnoreCase(hashcode, getVerificationHashcode(
				mobileNo, verificationCode)) >= 0;
	}

	public static void addVerificationCodeCookie(String mobileNo,
			String verificationCode, int cookieAgeUnitSec) {

		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		String verificationSMSHashcodes = CookieUtils.getCookieValue(
				CookieUtils.getCookie(VerificationSMS_Cookie_Name), "");

		if (!TypeChecker.isEmpty(verificationSMSHashcodes)) {

			String[] hashcodes = StringUtils.splitBySeparator(
					verificationSMSHashcodes,
					VerificationCode_Multiple_Separator);

			verificationSMSHashcodes = "";

			for (int i = hashcodes.length - 1; i >= Math
					.max(
							0,
							(hashcodes.length - (Last_VerificationCode_Valid_Number - 1))); i--) {
				verificationSMSHashcodes += ((hashcodes[i]) + VerificationCode_Multiple_Separator);
			}

			CookieUtils.addCookie(VerificationSMS_Cookie_Name,
					verificationSMSHashcodes
							+ VerificationCode_Multiple_Separator
							+ getVerificationHashcode(mobileNo,
									verificationCode), cookieAgeUnitSec);

			return;
		}

		CookieUtils.addCookie(VerificationSMS_Cookie_Name,
				getVerificationHashcode(mobileNo, verificationCode),
				cookieAgeUnitSec);
	}

	public static boolean isVerificationCodeValidByCookie(String mobileNo,
			String verificationCode) {
		verificationCode = StringUtils.trimToEmpty(verificationCode)
				.toLowerCase();

		if (TypeChecker.isEmpty(verificationCode)
				|| TypeChecker.isEmpty(mobileNo)) {
			return false;
		}

		String hashVerificatonCode = getVerificationHashcode(mobileNo,
				verificationCode);

		return StringUtils.containsIgnoreCase(CookieUtils.getCookieValue(
				CookieUtils.getCookie(VerificationSMS_Cookie_Name), ""),
				hashVerificatonCode, VerificationCode_Multiple_Separator);

	}

	private VerificationSMSCodeUtils() {

	}

	public static void main(String[] args) {

	}

	private static final int Verfication_Length = 6;

	private static final String Mobile_Verification_Codes = "0123456789";

	private static final String VerificationSMS_Cookie_Name = "sso-johnhao-sms-cookie4";

	private static final int Last_VerificationCode_Valid_Number = 3;

	public static final String VerificationCode_Multiple_Separator = "|";
}
