package com.rapid.j2ee.framework.dispatcher;

import java.io.StringWriter;
import java.util.Date;
import java.util.Map;

import org.apache.http.Header;
import org.dom4j.io.OutputFormat;

import com.rapid.j2ee.framework.core.io.xml.XmlWriter;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.rapid.j2ee.framework.dispatcher.lookup.DispatchConfigurer;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;

public class RequestDispatchContext {

	private WebUser webUser;

	private String resultId;

	private Date startDate;

	private Date endDate;

	private String dispatchedRequestContent;

	private DispatchConfigurer dispatcherConfigurer;

	private String error;

	private Map<String, String[]> requestDispatchedParameters;

	private Header[] responseDispatchedHeaders;

	public Map<String, String[]> getRequestDispatchedParameters() {
		return requestDispatchedParameters;
	}

	public void setRequestDispatchedParameters(
			Map<String, String[]> requestDispatchedParameters) {
		this.requestDispatchedParameters = requestDispatchedParameters;
	}

	public RequestDispatchContext() {

		startDate = DateTimeUtils.getCurrentDate();

		resultId = "Dispatch_" + UUIDGenerator.nextUUID();
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public DispatchConfigurer getDispatcherConfigurer() {
		return dispatcherConfigurer;
	}

	public void setDispatcherConfigurer(
			DispatchConfigurer dispatcherConfigurer) {
		this.dispatcherConfigurer = dispatcherConfigurer;
	}

	public String getDispatchedRequestContent() {
		return dispatchedRequestContent;
	}

	public void setDispatchedRequestContent(String dispatchedRequestContent) {
		this.dispatchedRequestContent = dispatchedRequestContent;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void end() {
		this.endDate = DateTimeUtils.getCurrentDate();
	}

	public Date getStartDate() {
		return startDate;
	}

	public boolean hasError() {
		return !TypeChecker.isEmpty(this.error);
	}

	public String getResultId() {
		return resultId;
	}

	public WebUser getWebUser() {
		return webUser;
	}

	public void setWebUser(WebUser webUser) {
		this.webUser = webUser;
	}

	public Header[] getResponseDispatchedHeaders() {
		return responseDispatchedHeaders;
	}

	public void setResponseDispatchedHeaders(Header[] responseDispatchedHeaders) {
		this.responseDispatchedHeaders = responseDispatchedHeaders;
	}

	public String getResponseHeaderXml() {

		XmlWriter xmlWriter = new XmlWriter();
		xmlWriter.addRootElement("response");
		xmlWriter.addElement("headers");

		if (TypeChecker.isEmpty(this.responseDispatchedHeaders)) {
			return xmlWriter.toXmlText();
		}

		for (Header header : responseDispatchedHeaders) {

			xmlWriter.addElement("header");

			xmlWriter.addElementAttribute("name", header.getName());
			xmlWriter.addElementAttribute("value", header.getValue());

			xmlWriter.moveByElementName("headers");
		}

		return xmlWriter.toXmlText(OutputFormat.createPrettyPrint());

	}

	public String getRequestParametersXml() {

		XmlWriter xmlWriter = new XmlWriter();
		xmlWriter.addRootElement("request");

		xmlWriter.addElement("Url");

		if (!TypeChecker.isNull(this.getDispatcherConfigurer())) {
			xmlWriter.addElementText(this.getDispatcherConfigurer().getUrl());
		}

		xmlWriter.moveByElementName("request");

		xmlWriter.addElement("parameters");

		if (TypeChecker.isEmpty(requestDispatchedParameters)) {
			return xmlWriter.toXmlText();
		}

		for (String parameterName : requestDispatchedParameters.keySet()) {
			for (String value : requestDispatchedParameters.get(parameterName)) {
				xmlWriter.addElement("parameter");
				xmlWriter.addElementAttribute("name", parameterName);
				xmlWriter.addElementAttribute("value", value);

				xmlWriter.moveByElementName("parameters");

			}
		}

		return xmlWriter.toXmlText(OutputFormat.createPrettyPrint());

	}

	public String getDistpacheRequestFullContent() {

		StringWriter sw = new StringWriter(1000);

		String parameterXml = this.getRequestParametersXml();

		sw.write(StringUtils.substringBefore(parameterXml, "?>") + "?>");

		sw.write("\r\n<logger>");

		sw.write(StringUtils.substringAfter(parameterXml, "?>"));

		sw.write(StringUtils.substringAfter(this.getResponseHeaderXml(), "?>"));

		sw.write(StringUtils.substringAfter(this.getDispatchedRequestContent(),
				"?>"));

		sw.write("</logger>");

		return sw.toString();

	}

}
