package com.rapid.j2ee.framework.dispatcher;

import java.util.Collection;

import com.rapid.j2ee.framework.core.utils.Constants;

public class RequestDispatcherConstants {

	public static enum AccessMode {

		Download("Resource", true), Html("Html", false), Json("Json", false), Xml(
				"XML", false), Unkown("Unkown", false);

		private String mode;

		private boolean resourceForDownload;

		private AccessMode(String mode, boolean resourceForDownload) {
			this.mode = mode;
			this.resourceForDownload = resourceForDownload;
		}

		public String getMode() {
			return mode;
		}

		public boolean isResourceForDownload() {
			return resourceForDownload;
		}

	}

	public static final Collection<AccessMode> accessModels = new Constants(
			AccessMode.class).getFieldCache().values();

	public static AccessMode getAccessMode(String modeName) {

		for (AccessMode mode : accessModels) {
			if (mode.getMode().equalsIgnoreCase(modeName)) {
				return mode;
			}
		}

		throw new IllegalArgumentException("Sorry, the mode name [" + modeName
				+ "] cannot be supported!");
	}

}
